/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputGateListener;

public class MockInputGate
implements InputGate {
    private final int pageSize;
    private final int numChannels;
    private final Queue<BufferOrEvent> bufferOrEvents;
    private final boolean[] closed;
    private int closedChannels;
    private final String owningTaskName;

    public MockInputGate(int pageSize, int numChannels, List<BufferOrEvent> bufferOrEvents) {
        this(pageSize, numChannels, bufferOrEvents, "MockTask");
    }

    public MockInputGate(int pageSize, int numChannels, List<BufferOrEvent> bufferOrEvents, String owningTaskName) {
        this.pageSize = pageSize;
        this.numChannels = numChannels;
        this.bufferOrEvents = new ArrayDeque<BufferOrEvent>(bufferOrEvents);
        this.closed = new boolean[numChannels];
        this.owningTaskName = owningTaskName;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getNumberOfInputChannels() {
        return this.numChannels;
    }

    public String getOwningTaskName() {
        return this.owningTaskName;
    }

    public boolean isFinished() {
        return this.bufferOrEvents.isEmpty();
    }

    public Optional<BufferOrEvent> getNextBufferOrEvent() {
        BufferOrEvent next = this.bufferOrEvents.poll();
        if (next == null) {
            return Optional.empty();
        }
        int channelIdx = next.getChannelIndex();
        if (this.closed[channelIdx]) {
            throw new RuntimeException("Inconsistent: Channel " + channelIdx + " has data even though it is already closed.");
        }
        if (next.isEvent() && next.getEvent() instanceof EndOfPartitionEvent) {
            this.closed[channelIdx] = true;
            ++this.closedChannels;
        }
        return Optional.of(next);
    }

    public Optional<BufferOrEvent> pollNextBufferOrEvent() {
        return this.getNextBufferOrEvent();
    }

    public void requestPartitions() {
    }

    public void sendTaskEvent(TaskEvent event) {
    }

    public void registerListener(InputGateListener listener) {
    }
}

