/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.streaming.runtime.io.BarrierBuffer;
import org.apache.flink.streaming.runtime.io.BarrierBufferTestBase;
import org.apache.flink.streaming.runtime.io.BufferBlocker;
import org.apache.flink.streaming.runtime.io.CachedBufferBlocker;
import org.junit.Assert;

public class CreditBasedBarrierBufferTest
extends BarrierBufferTestBase {
    @Override
    public BarrierBuffer createBarrierHandler(InputGate gate) throws IOException {
        return new BarrierBuffer(gate, (BufferBlocker)new CachedBufferBlocker(512));
    }

    @Override
    public void validateAlignmentBuffered(long actualBytesBuffered, BufferOrEvent ... sequence) {
        long expectedBuffered = 0L;
        for (BufferOrEvent boe : sequence) {
            if (!boe.isBuffer()) continue;
            expectedBuffered += 512L;
        }
        Assert.assertEquals((String)"Wrong alignment buffered bytes", (long)actualBytesBuffered, (long)expectedBuffered);
    }
}

