/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.File;
import java.io.IOException;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.streaming.runtime.io.BufferBlocker;
import org.apache.flink.streaming.runtime.io.BufferBlockerTestBase;
import org.apache.flink.streaming.runtime.io.BufferSpiller;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BufferSpillerTest
extends BufferBlockerTestBase {
    private static IOManager ioManager;
    private BufferSpiller spiller;

    @BeforeClass
    public static void setupIOManager() {
        ioManager = new IOManagerAsync();
    }

    @AfterClass
    public static void shutdownIOManager() {
        ioManager.shutdown();
    }

    @Before
    public void createSpiller() throws IOException {
        this.spiller = new BufferSpiller(ioManager, 4096);
    }

    @After
    public void cleanupSpiller() throws IOException {
        if (this.spiller != null) {
            this.spiller.close();
            Assert.assertFalse((boolean)this.spiller.getCurrentChannel().isOpen());
            Assert.assertFalse((boolean)this.spiller.getCurrentSpillFile().exists());
        }
        BufferSpillerTest.checkNoTempFilesRemain();
    }

    @Override
    public BufferBlocker createBufferBlocker() {
        return this.spiller;
    }

    @Test
    public void testHeaderSizeStaticField() throws Exception {
        int size = 13;
        BufferOrEvent boe = BufferSpillerTest.generateRandomBuffer(size, 0);
        this.spiller.add(boe);
        Assert.assertEquals((String)"Changed the header format, but did not adjust the HEADER_SIZE field", (long)(9 + size), (long)this.spiller.getBytesBlocked());
    }

    private static void checkNoTempFilesRemain() {
        for (File dir : ioManager.getSpillingDirectories()) {
            for (String file : dir.list()) {
                if (file == null || file.equals(".") || file.equals("..")) continue;
                Assert.fail((String)("barrier buffer did not clean up temp files. remaining file: " + file));
            }
        }
    }
}

