/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.decline.CheckpointDeclineOnCancellationBarrierException;
import org.apache.flink.runtime.checkpoint.decline.CheckpointDeclineSubsumedException;
import org.apache.flink.runtime.checkpoint.decline.InputEndOfStreamException;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.streaming.runtime.io.BarrierBuffer;
import org.apache.flink.streaming.runtime.io.MockInputGate;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

public abstract class BarrierBufferTestBase {
    protected static final int PAGE_SIZE = 512;
    private static final Random RND = new Random();
    private static int sizeCounter = 1;

    abstract BarrierBuffer createBarrierHandler(InputGate var1) throws IOException;

    abstract void validateAlignmentBuffered(long var1, BufferOrEvent ... var3);

    @Test
    public void testSingleChannelNoBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createEndOfPartition(0)};
        MockInputGate gate = new MockInputGate(512, 1, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        for (BufferOrEvent boe : sequence) {
            Assert.assertEquals((Object)boe, (Object)buffer.getNextNonBlocked());
        }
        Assert.assertEquals((long)0L, (long)buffer.getAlignmentDurationNanos());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
    }

    @Test
    public void testMultiChannelNoBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createEndOfPartition(0), BarrierBufferTestBase.createBuffer(3, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createEndOfPartition(3), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createEndOfPartition(1), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createEndOfPartition(2)};
        MockInputGate gate = new MockInputGate(512, 4, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        for (BufferOrEvent boe : sequence) {
            Assert.assertEquals((Object)boe, (Object)buffer.getNextNonBlocked());
        }
        Assert.assertEquals((long)0L, (long)buffer.getAlignmentDurationNanos());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
    }

    @Test
    public void testSingleChannelWithBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(1L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(2L, 0), BarrierBufferTestBase.createBarrier(3L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(4L, 0), BarrierBufferTestBase.createBarrier(5L, 0), BarrierBufferTestBase.createBarrier(6L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createEndOfPartition(0)};
        MockInputGate gate = new MockInputGate(512, 1, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        ValidatingCheckpointHandler handler = new ValidatingCheckpointHandler();
        buffer.registerCheckpointEventHandler((AbstractInvokable)handler);
        handler.setNextExpectedCheckpointId(1L);
        for (BufferOrEvent boe : sequence) {
            if (!boe.isBuffer() && boe.getEvent().getClass() == CheckpointBarrier.class) continue;
            Assert.assertEquals((Object)boe, (Object)buffer.getNextNonBlocked());
        }
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
    }

    @Test
    public void testMultiChannelWithBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(1L, 1), BarrierBufferTestBase.createBarrier(1L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(1L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(2L, 0), BarrierBufferTestBase.createBarrier(2L, 1), BarrierBufferTestBase.createBarrier(2L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(3L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(3L, 0), BarrierBufferTestBase.createBarrier(3L, 1), BarrierBufferTestBase.createBarrier(4L, 1), BarrierBufferTestBase.createBarrier(4L, 2), BarrierBufferTestBase.createBarrier(4L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(5L, 1), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBarrier(5L, 2), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBarrier(5L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createEndOfPartition(0), BarrierBufferTestBase.createEndOfPartition(1), BarrierBufferTestBase.createEndOfPartition(2)};
        MockInputGate gate = new MockInputGate(512, 3, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        ValidatingCheckpointHandler handler = new ValidatingCheckpointHandler();
        buffer.registerCheckpointEventHandler((AbstractInvokable)handler);
        handler.setNextExpectedCheckpointId(1L);
        BarrierBufferTestBase.check(sequence[0], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[1], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[2], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)1L, (long)handler.getNextExpectedCheckpointId());
        long startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[7], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)1L, (long)handler.getNextExpectedCheckpointId());
        BarrierBufferTestBase.check(sequence[5], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)2L, (long)handler.getNextExpectedCheckpointId());
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        this.validateAlignmentBuffered(handler.getLastReportedBytesBufferedInAlignment(), sequence[5], sequence[6]);
        BarrierBufferTestBase.check(sequence[6], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[9], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[10], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[11], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[12], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[13], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)2L, (long)handler.getNextExpectedCheckpointId());
        startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[17], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)3L, (long)handler.getNextExpectedCheckpointId());
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        this.validateAlignmentBuffered(handler.getLastReportedBytesBufferedInAlignment(), new BufferOrEvent[0]);
        BarrierBufferTestBase.check(sequence[18], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[20], buffer.getNextNonBlocked(), 512);
        this.validateAlignmentBuffered(handler.getLastReportedBytesBufferedInAlignment(), sequence[20], sequence[21]);
        Assert.assertEquals((long)4L, (long)handler.getNextExpectedCheckpointId());
        BarrierBufferTestBase.check(sequence[21], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[27], buffer.getNextNonBlocked(), 512);
        this.validateAlignmentBuffered(handler.getLastReportedBytesBufferedInAlignment(), new BufferOrEvent[0]);
        Assert.assertEquals((long)5L, (long)handler.getNextExpectedCheckpointId());
        BarrierBufferTestBase.check(sequence[28], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[29], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[31], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[32], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[33], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[37], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[34], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[36], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[38], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[39], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[41], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[42], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[43], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[44], buffer.getNextNonBlocked(), 512);
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        this.validateAlignmentBuffered(handler.getLastReportedBytesBufferedInAlignment(), sequence[34], sequence[36], sequence[38], sequence[39]);
        buffer.cleanup();
    }

    @Test
    public void testMultiChannelTrailingBlockedData() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(1L, 1), BarrierBufferTestBase.createBarrier(1L, 2), BarrierBufferTestBase.createBarrier(1L, 0), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(2L, 1), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createEndOfPartition(1), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(2L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createEndOfPartition(2), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createEndOfPartition(0)};
        MockInputGate gate = new MockInputGate(512, 3, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        ValidatingCheckpointHandler handler = new ValidatingCheckpointHandler();
        buffer.registerCheckpointEventHandler((AbstractInvokable)handler);
        handler.setNextExpectedCheckpointId(1L);
        BarrierBufferTestBase.check(sequence[0], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[1], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[2], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)1L, (long)handler.getNextExpectedCheckpointId());
        BarrierBufferTestBase.check(sequence[6], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)2L, (long)handler.getNextExpectedCheckpointId());
        BarrierBufferTestBase.check(sequence[7], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[8], buffer.getNextNonBlocked(), 512);
        long startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[13], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[14], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[18], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[19], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        BarrierBufferTestBase.check(sequence[10], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[11], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[12], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[16], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[17], buffer.getNextNonBlocked(), 512);
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
    }

    @Test
    public void testMultiChannelWithQueuedFutureBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(1L, 1), BarrierBufferTestBase.createBarrier(1L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(1L, 0), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(2L, 1), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(2L, 0), BarrierBufferTestBase.createBarrier(3L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(3L, 1), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(4L, 1), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(2L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(4L, 0), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(5L, 1), BarrierBufferTestBase.createBarrier(3L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(6L, 1), BarrierBufferTestBase.createBarrier(4L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createEndOfPartition(1), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createEndOfPartition(2), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createEndOfPartition(0)};
        MockInputGate gate = new MockInputGate(512, 3, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        ValidatingCheckpointHandler handler = new ValidatingCheckpointHandler();
        buffer.registerCheckpointEventHandler((AbstractInvokable)handler);
        handler.setNextExpectedCheckpointId(1L);
        BarrierBufferTestBase.check(sequence[0], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[1], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[2], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[7], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[5], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)2L, (long)handler.getNextExpectedCheckpointId());
        BarrierBufferTestBase.check(sequence[6], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[9], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[10], buffer.getNextNonBlocked(), 512);
        long startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[13], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[20], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[23], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[12], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        BarrierBufferTestBase.check(sequence[25], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[27], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[30], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[32], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[16], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[18], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[19], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[28], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[36], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[38], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[22], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[26], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[31], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[33], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[39], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[42], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[45], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[46], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[37], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[47], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[48], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[43], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[44], buffer.getNextNonBlocked(), 512);
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
    }

    @Test
    public void testMultiChannelSkippingCheckpoints() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(1L, 1), BarrierBufferTestBase.createBarrier(1L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(1L, 0), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(2L, 1), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(2L, 0), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(3L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createEndOfPartition(1), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createEndOfPartition(2), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createEndOfPartition(0)};
        MockInputGate gate = new MockInputGate(512, 3, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        AbstractInvokable toNotify = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        buffer.registerCheckpointEventHandler(toNotify);
        BarrierBufferTestBase.check(sequence[0], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[1], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[2], buffer.getNextNonBlocked(), 512);
        long startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[7], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)1L, (long)buffer.getCurrentCheckpointId());
        BarrierBufferTestBase.check(sequence[5], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        ((AbstractInvokable)Mockito.verify((Object)toNotify)).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(1L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        BarrierBufferTestBase.check(sequence[6], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[9], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[10], buffer.getNextNonBlocked(), 512);
        startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[13], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[15], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[12], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)3L, (long)buffer.getCurrentCheckpointId());
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        ((AbstractInvokable)Mockito.verify((Object)toNotify)).abortCheckpointOnBarrier(Matchers.eq((long)2L), (Throwable)ArgumentMatchers.isA(CheckpointDeclineSubsumedException.class));
        BarrierBufferTestBase.check(sequence[16], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[19], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[20], buffer.getNextNonBlocked(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify)).abortCheckpointOnBarrier(Matchers.eq((long)3L), (Throwable)ArgumentMatchers.isA(InputEndOfStreamException.class));
        BarrierBufferTestBase.check(sequence[18], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[21], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[22], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[23], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[24], buffer.getNextNonBlocked(), 512);
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
    }

    @Test
    public void testMultiChannelJumpingOverCheckpoint() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(1L, 1), BarrierBufferTestBase.createBarrier(1L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(1L, 0), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(2L, 1), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(2L, 0), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(3L, 1), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(3L, 0), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(4L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createEndOfPartition(1), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createEndOfPartition(2), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createEndOfPartition(0)};
        MockInputGate gate = new MockInputGate(512, 3, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        ValidatingCheckpointHandler handler = new ValidatingCheckpointHandler();
        buffer.registerCheckpointEventHandler((AbstractInvokable)handler);
        handler.setNextExpectedCheckpointId(1L);
        BarrierBufferTestBase.check(sequence[0], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[1], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[2], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[7], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)1L, (long)buffer.getCurrentCheckpointId());
        BarrierBufferTestBase.check(sequence[5], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[6], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[9], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[10], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[13], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)2L, (long)buffer.getCurrentCheckpointId());
        BarrierBufferTestBase.check(sequence[15], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[19], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[21], buffer.getNextNonBlocked(), 512);
        long startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[12], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)4L, (long)buffer.getCurrentCheckpointId());
        BarrierBufferTestBase.check(sequence[16], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[18], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[22], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[25], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[26], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        BarrierBufferTestBase.check(sequence[24], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[27], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[28], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[29], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[30], buffer.getNextNonBlocked(), 512);
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
    }

    @Test
    public void testMultiChannelSkippingCheckpointsViaBlockedInputs() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(1L, 1), BarrierBufferTestBase.createBarrier(1L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(1L, 0), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(2L, 1), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(2L, 0), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(3L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(4L, 1), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(2L, 2), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(3L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(4L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(4L, 2), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createEndOfPartition(1), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createEndOfPartition(2), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createEndOfPartition(0)};
        MockInputGate gate = new MockInputGate(512, 3, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        BarrierBufferTestBase.check(sequence[0], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[1], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[2], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[7], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)1L, (long)buffer.getCurrentCheckpointId());
        BarrierBufferTestBase.check(sequence[5], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[6], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[9], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[10], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[13], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[22], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)2L, (long)buffer.getCurrentCheckpointId());
        BarrierBufferTestBase.check(sequence[12], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[15], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[16], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[18], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)4L, (long)buffer.getCurrentCheckpointId());
        BarrierBufferTestBase.check(sequence[21], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[24], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[26], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[30], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[20], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[28], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[29], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[32], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[33], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[34], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[35], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[36], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[37], buffer.getNextNonBlocked(), 512);
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
    }

    @Test
    public void testEarlyCleanup() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(1L, 1), BarrierBufferTestBase.createBarrier(1L, 2), BarrierBufferTestBase.createBarrier(1L, 0), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(2L, 1), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createEndOfPartition(1), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(2L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createEndOfPartition(2), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createEndOfPartition(0)};
        MockInputGate gate = new MockInputGate(512, 3, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        ValidatingCheckpointHandler handler = new ValidatingCheckpointHandler();
        buffer.registerCheckpointEventHandler((AbstractInvokable)handler);
        handler.setNextExpectedCheckpointId(1L);
        BarrierBufferTestBase.check(sequence[0], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[1], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[2], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)1L, (long)handler.getNextExpectedCheckpointId());
        BarrierBufferTestBase.check(sequence[6], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)2L, (long)handler.getNextExpectedCheckpointId());
        BarrierBufferTestBase.check(sequence[7], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[8], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[13], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[14], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[18], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[19], buffer.getNextNonBlocked(), 512);
        buffer.getNextNonBlocked();
        buffer.cleanup();
    }

    @Test
    public void testStartAlignmentWithClosedChannels() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createEndOfPartition(2), BarrierBufferTestBase.createEndOfPartition(1), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(3, 512), BarrierBufferTestBase.createBarrier(2L, 3), BarrierBufferTestBase.createBarrier(2L, 0), BarrierBufferTestBase.createBuffer(3, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(3L, 3), BarrierBufferTestBase.createBuffer(3, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(3L, 0), BarrierBufferTestBase.createBarrier(4L, 0), BarrierBufferTestBase.createBarrier(4L, 3), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(3, 512), BarrierBufferTestBase.createEndOfPartition(0), BarrierBufferTestBase.createBuffer(3, 512), BarrierBufferTestBase.createBarrier(5L, 3), BarrierBufferTestBase.createBuffer(3, 512), BarrierBufferTestBase.createEndOfPartition(3)};
        MockInputGate gate = new MockInputGate(512, 4, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        BarrierBufferTestBase.check(sequence[0], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[1], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[2], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[3], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[4], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[7], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)2L, (long)buffer.getCurrentCheckpointId());
        BarrierBufferTestBase.check(sequence[8], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[11], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[10], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)3L, (long)buffer.getCurrentCheckpointId());
        BarrierBufferTestBase.check(sequence[15], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)4L, (long)buffer.getCurrentCheckpointId());
        BarrierBufferTestBase.check(sequence[16], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[17], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[18], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[19], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[21], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)5L, (long)buffer.getCurrentCheckpointId());
        BarrierBufferTestBase.check(sequence[22], buffer.getNextNonBlocked(), 512);
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
    }

    @Test
    public void testEndOfStreamWhileCheckpoint() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBarrier(1L, 0), BarrierBufferTestBase.createBarrier(1L, 1), BarrierBufferTestBase.createBarrier(1L, 2), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(2L, 2), BarrierBufferTestBase.createBarrier(2L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createEndOfPartition(2), BarrierBufferTestBase.createEndOfPartition(1), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createEndOfPartition(0)};
        MockInputGate gate = new MockInputGate(512, 3, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        BarrierBufferTestBase.check(sequence[3], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[4], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[5], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)1L, (long)buffer.getCurrentCheckpointId());
        BarrierBufferTestBase.check(sequence[10], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)2L, (long)buffer.getCurrentCheckpointId());
        BarrierBufferTestBase.check(sequence[12], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[8], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[9], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[11], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[13], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[14], buffer.getNextNonBlocked(), 512);
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
    }

    @Test
    public void testSingleChannelAbortCheckpoint() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(1L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(2L, 0), BarrierBufferTestBase.createCancellationBarrier(4L, 0), BarrierBufferTestBase.createBarrier(5L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createCancellationBarrier(6L, 0), BarrierBufferTestBase.createBuffer(0, 512)};
        MockInputGate gate = new MockInputGate(512, 1, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        AbstractInvokable toNotify = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        buffer.registerCheckpointEventHandler(toNotify);
        BarrierBufferTestBase.check(sequence[0], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[2], buffer.getNextNonBlocked(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(1L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        Assert.assertEquals((long)0L, (long)buffer.getAlignmentDurationNanos());
        BarrierBufferTestBase.check(sequence[6], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)5L, (long)buffer.getCurrentCheckpointId());
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(2L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.eq((long)4L), (Throwable)Matchers.any(CheckpointDeclineOnCancellationBarrierException.class));
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(5L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        Assert.assertEquals((long)0L, (long)buffer.getAlignmentDurationNanos());
        BarrierBufferTestBase.check(sequence[8], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)6L, (long)buffer.getCurrentCheckpointId());
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.eq((long)6L), (Throwable)Matchers.any(CheckpointDeclineOnCancellationBarrierException.class));
        Assert.assertEquals((long)0L, (long)buffer.getAlignmentDurationNanos());
        buffer.cleanup();
    }

    @Test
    public void testMultiChannelAbortCheckpoint() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(1L, 1), BarrierBufferTestBase.createBarrier(1L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBarrier(1L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(2L, 0), BarrierBufferTestBase.createBarrier(2L, 2), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createCancellationBarrier(2L, 1), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBarrier(3L, 1), BarrierBufferTestBase.createBarrier(3L, 2), BarrierBufferTestBase.createBarrier(3L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createCancellationBarrier(4L, 1), BarrierBufferTestBase.createBarrier(4L, 2), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(4L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(5L, 2), BarrierBufferTestBase.createBarrier(5L, 1), BarrierBufferTestBase.createBarrier(5L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createCancellationBarrier(6L, 1), BarrierBufferTestBase.createCancellationBarrier(6L, 2), BarrierBufferTestBase.createBarrier(6L, 0), BarrierBufferTestBase.createBuffer(0, 512)};
        MockInputGate gate = new MockInputGate(512, 3, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        AbstractInvokable toNotify = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        buffer.registerCheckpointEventHandler(toNotify);
        BarrierBufferTestBase.check(sequence[0], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[1], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[2], buffer.getNextNonBlocked(), 512);
        long startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[5], buffer.getNextNonBlocked(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(1L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        BarrierBufferTestBase.check(sequence[6], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[8], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[9], buffer.getNextNonBlocked(), 512);
        startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[12], buffer.getNextNonBlocked(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.eq((long)2L), (Throwable)Matchers.any(CheckpointDeclineOnCancellationBarrierException.class));
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        BarrierBufferTestBase.check(sequence[13], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[15], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[16], buffer.getNextNonBlocked(), 512);
        startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[20], buffer.getNextNonBlocked(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(3L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        BarrierBufferTestBase.check(sequence[21], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[24], buffer.getNextNonBlocked(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.eq((long)4L), (Throwable)Matchers.any(CheckpointDeclineOnCancellationBarrierException.class));
        Assert.assertEquals((long)0L, (long)buffer.getAlignmentDurationNanos());
        BarrierBufferTestBase.check(sequence[26], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[27], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[28], buffer.getNextNonBlocked(), 512);
        startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[32], buffer.getNextNonBlocked(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(5L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        BarrierBufferTestBase.check(sequence[33], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[37], buffer.getNextNonBlocked(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.eq((long)6L), (Throwable)Matchers.any(CheckpointDeclineOnCancellationBarrierException.class));
        Assert.assertEquals((long)0L, (long)buffer.getAlignmentDurationNanos());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
    }

    @Test
    public void testAbortViaQueuedBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBarrier(1L, 1), BarrierBufferTestBase.createBarrier(1L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createCancellationBarrier(2L, 2), BarrierBufferTestBase.createBarrier(2L, 1), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(1L, 0), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(2L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512)};
        MockInputGate gate = new MockInputGate(512, 3, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        AbstractInvokable toNotify = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        buffer.registerCheckpointEventHandler(toNotify);
        BarrierBufferTestBase.check(sequence[0], buffer.getNextNonBlocked(), 512);
        long startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[4], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[8], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[3], buffer.getNextNonBlocked(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(1L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        BarrierBufferTestBase.check(sequence[5], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[9], buffer.getNextNonBlocked(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.eq((long)2L), (Throwable)Matchers.any(CheckpointDeclineOnCancellationBarrierException.class));
        Assert.assertEquals((long)0L, (long)buffer.getAlignmentDurationNanos());
        BarrierBufferTestBase.check(sequence[10], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[12], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[13], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[14], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[16], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[17], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[18], buffer.getNextNonBlocked(), 512);
        Assert.assertEquals((long)0L, (long)buffer.getAlignmentDurationNanos());
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)Matchers.any(CheckpointMetaData.class), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.anyLong(), (Throwable)Matchers.any(CheckpointDeclineOnCancellationBarrierException.class));
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
    }

    @Test
    public void testAbortWhileHavingQueuedBarriers() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBarrier(1L, 1), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBarrier(2L, 1), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createCancellationBarrier(1L, 0), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBarrier(1L, 2), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(2L, 0), BarrierBufferTestBase.createBarrier(2L, 2), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512)};
        MockInputGate gate = new MockInputGate(512, 3, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        AbstractInvokable toNotify = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        buffer.registerCheckpointEventHandler(toNotify);
        BarrierBufferTestBase.check(sequence[0], buffer.getNextNonBlocked(), 512);
        long startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[2], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[3], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[6], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[4], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        ((AbstractInvokable)Mockito.verify((Object)toNotify)).abortCheckpointOnBarrier(Matchers.eq((long)1L), (Throwable)Matchers.any(CheckpointDeclineOnCancellationBarrierException.class));
        startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[9], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[11], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[13], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[15], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[7], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        ((AbstractInvokable)Mockito.verify((Object)toNotify)).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(2L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        BarrierBufferTestBase.check(sequence[10], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[14], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[18], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[19], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[20], buffer.getNextNonBlocked(), 512);
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)Matchers.any(CheckpointMetaData.class), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.anyLong(), (Throwable)Matchers.any(Throwable.class));
    }

    @Test
    public void testIgnoreCancelBarrierIfCheckpointSubsumed() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(3L, 1), BarrierBufferTestBase.createBarrier(3L, 0), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBarrier(5L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createCancellationBarrier(3L, 2), BarrierBufferTestBase.createBuffer(2, 512), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBarrier(5L, 0), BarrierBufferTestBase.createBarrier(5L, 1), BarrierBufferTestBase.createBuffer(0, 512), BarrierBufferTestBase.createBuffer(1, 512), BarrierBufferTestBase.createBuffer(2, 512)};
        MockInputGate gate = new MockInputGate(512, 3, Arrays.asList(sequence));
        BarrierBuffer buffer = this.createBarrierHandler(gate);
        AbstractInvokable toNotify = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        buffer.registerCheckpointEventHandler(toNotify);
        BarrierBufferTestBase.check(sequence[0], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[5], buffer.getNextNonBlocked(), 512);
        long startTs = System.nanoTime();
        BarrierBufferTestBase.check(sequence[3], buffer.getNextNonBlocked(), 512);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.eq((long)3L), (Throwable)Matchers.any(CheckpointDeclineSubsumedException.class));
        BarrierBufferTestBase.check(sequence[4], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[8], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[9], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[12], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[13], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[7], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.validateAlignmentTime(startTs, buffer.getAlignmentDurationNanos());
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(5L)), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        BarrierBufferTestBase.check(sequence[11], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[16], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[17], buffer.getNextNonBlocked(), 512);
        BarrierBufferTestBase.check(sequence[18], buffer.getNextNonBlocked(), 512);
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)Matchers.any(CheckpointMetaData.class), (CheckpointOptions)Matchers.any(CheckpointOptions.class), (CheckpointMetrics)Matchers.any(CheckpointMetrics.class));
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Matchers.anyLong(), (Throwable)Matchers.any(Throwable.class));
    }

    private static BufferOrEvent createBarrier(long checkpointId, int channel) {
        return new BufferOrEvent((AbstractEvent)new CheckpointBarrier(checkpointId, System.currentTimeMillis(), CheckpointOptions.forCheckpointWithDefaultLocation()), channel);
    }

    private static BufferOrEvent createCancellationBarrier(long checkpointId, int channel) {
        return new BufferOrEvent((AbstractEvent)new CancelCheckpointMarker(checkpointId), channel);
    }

    private static BufferOrEvent createBuffer(int channel, int pageSize) {
        int size = sizeCounter++;
        byte[] bytes = new byte[size];
        RND.nextBytes(bytes);
        MemorySegment memory = MemorySegmentFactory.allocateUnpooledSegment((int)pageSize);
        memory.put(0, bytes);
        NetworkBuffer buf = new NetworkBuffer(memory, FreeingBufferRecycler.INSTANCE);
        buf.setSize(size);
        buf.retainBuffer();
        return new BufferOrEvent((Buffer)buf, channel);
    }

    private static BufferOrEvent createEndOfPartition(int channel) {
        return new BufferOrEvent((AbstractEvent)EndOfPartitionEvent.INSTANCE, channel);
    }

    private static void check(BufferOrEvent expected, BufferOrEvent present, int pageSize) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)present);
        Assert.assertEquals((Object)expected.isBuffer(), (Object)present.isBuffer());
        if (expected.isBuffer()) {
            Assert.assertEquals((long)expected.getBuffer().getMaxCapacity(), (long)present.getBuffer().getMaxCapacity());
            Assert.assertEquals((long)expected.getBuffer().getSize(), (long)present.getBuffer().getSize());
            MemorySegment expectedMem = expected.getBuffer().getMemorySegment();
            MemorySegment presentMem = present.getBuffer().getMemorySegment();
            Assert.assertTrue((String)"memory contents differs", (expectedMem.compare(presentMem, 0, 0, pageSize) == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((Object)expected.getEvent(), (Object)present.getEvent());
        }
    }

    private static void validateAlignmentTime(long startTimestamp, long alignmentDuration) {
        long elapsed = System.nanoTime() - startTimestamp;
        Assert.assertTrue((String)"wrong alignment time", (alignmentDuration <= elapsed ? 1 : 0) != 0);
    }

    private static class CheckpointMatcher
    extends BaseMatcher<CheckpointMetaData> {
        private final long checkpointId;

        CheckpointMatcher(long checkpointId) {
            this.checkpointId = checkpointId;
        }

        public boolean matches(Object o) {
            return o != null && o.getClass() == CheckpointMetaData.class && ((CheckpointMetaData)o).getCheckpointId() == this.checkpointId;
        }

        public void describeTo(Description description) {
            description.appendText("CheckpointMetaData - id = " + this.checkpointId);
        }
    }

    private static class ValidatingCheckpointHandler
    extends AbstractInvokable {
        private long nextExpectedCheckpointId = -1L;
        private long lastReportedBytesBufferedInAlignment = -1L;

        public ValidatingCheckpointHandler() {
            super((Environment)new DummyEnvironment("test", 1, 0));
        }

        public void setNextExpectedCheckpointId(long nextExpectedCheckpointId) {
            this.nextExpectedCheckpointId = nextExpectedCheckpointId;
        }

        public long getNextExpectedCheckpointId() {
            return this.nextExpectedCheckpointId;
        }

        long getLastReportedBytesBufferedInAlignment() {
            return this.lastReportedBytesBufferedInAlignment;
        }

        public void invoke() {
            throw new UnsupportedOperationException();
        }

        public boolean triggerCheckpoint(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions) throws Exception {
            throw new UnsupportedOperationException("should never be called");
        }

        public void triggerCheckpointOnBarrier(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointMetrics checkpointMetrics) throws Exception {
            Assert.assertTrue((String)"wrong checkpoint id", (this.nextExpectedCheckpointId == -1L || this.nextExpectedCheckpointId == checkpointMetaData.getCheckpointId() ? 1 : 0) != 0);
            Assert.assertTrue((checkpointMetaData.getTimestamp() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((checkpointMetrics.getBytesBufferedInAlignment() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((checkpointMetrics.getAlignmentDurationNanos() >= 0L ? 1 : 0) != 0);
            ++this.nextExpectedCheckpointId;
            this.lastReportedBytesBufferedInAlignment = checkpointMetrics.getBytesBufferedInAlignment();
        }

        public void abortCheckpointOnBarrier(long checkpointId, Throwable cause) {
        }

        public void notifyCheckpointComplete(long checkpointId) throws Exception {
            throw new UnsupportedOperationException("should never be called");
        }
    }
}

