/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.File;
import java.util.Arrays;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.decline.AlignmentLimitExceededException;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.streaming.runtime.io.BarrierBuffer;
import org.apache.flink.streaming.runtime.io.BufferBlocker;
import org.apache.flink.streaming.runtime.io.BufferSpiller;
import org.apache.flink.streaming.runtime.io.MockInputGate;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

public class BarrierBufferAlignmentLimitTest {
    private static final int PAGE_SIZE = 512;
    private static final Random RND = new Random();
    private static IOManager ioManager;

    @BeforeClass
    public static void setup() {
        ioManager = new IOManagerAsync();
    }

    @AfterClass
    public static void shutdownIOManager() {
        ioManager.shutdown();
    }

    @Test
    public void testBreakCheckpointAtAlignmentLimit() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferAlignmentLimitTest.createBuffer(1, 100), BarrierBufferAlignmentLimitTest.createBuffer(2, 70), BarrierBufferAlignmentLimitTest.createBuffer(0, 42), BarrierBufferAlignmentLimitTest.createBuffer(2, 111), BarrierBufferAlignmentLimitTest.createBarrier(7L, 1), BarrierBufferAlignmentLimitTest.createBuffer(1, 100), BarrierBufferAlignmentLimitTest.createBuffer(2, 200), BarrierBufferAlignmentLimitTest.createBuffer(1, 300), BarrierBufferAlignmentLimitTest.createBuffer(0, 50), BarrierBufferAlignmentLimitTest.createBarrier(7L, 0), BarrierBufferAlignmentLimitTest.createBuffer(2, 100), BarrierBufferAlignmentLimitTest.createBuffer(0, 100), BarrierBufferAlignmentLimitTest.createBuffer(1, 200), BarrierBufferAlignmentLimitTest.createBuffer(0, 200), BarrierBufferAlignmentLimitTest.createBuffer(0, 101), BarrierBufferAlignmentLimitTest.createBuffer(0, 100), BarrierBufferAlignmentLimitTest.createBuffer(1, 100), BarrierBufferAlignmentLimitTest.createBuffer(2, 100), BarrierBufferAlignmentLimitTest.createBarrier(7L, 2), BarrierBufferAlignmentLimitTest.createBuffer(0, 100), BarrierBufferAlignmentLimitTest.createBuffer(1, 100), BarrierBufferAlignmentLimitTest.createBuffer(2, 100)};
        MockInputGate gate = new MockInputGate(512, 3, Arrays.asList(sequence));
        BarrierBuffer buffer = new BarrierBuffer((InputGate)gate, (BufferBlocker)new BufferSpiller(ioManager, gate.getPageSize()), 1000L);
        AbstractInvokable toNotify = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        buffer.registerCheckpointEventHandler(toNotify);
        BarrierBufferAlignmentLimitTest.check(sequence[0], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[1], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[2], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[3], buffer.getNextNonBlocked());
        long startTs = System.nanoTime();
        BarrierBufferAlignmentLimitTest.check(sequence[6], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[8], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[10], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[5], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.validateAlignmentTime(startTs, buffer);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Mockito.eq((long)7L), (Throwable)Mockito.any(AlignmentLimitExceededException.class));
        BarrierBufferAlignmentLimitTest.check(sequence[7], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[11], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[12], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[13], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[14], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[15], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[16], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[17], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[19], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[20], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[21], buffer.getNextNonBlocked());
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)0))).triggerCheckpointOnBarrier((CheckpointMetaData)Mockito.any(CheckpointMetaData.class), (CheckpointOptions)Mockito.any(CheckpointOptions.class), (CheckpointMetrics)Mockito.any(CheckpointMetrics.class));
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
        BarrierBufferAlignmentLimitTest.checkNoTempFilesRemain();
    }

    @Test
    public void testAlignmentLimitWithQueuedAlignments() throws Exception {
        BufferOrEvent[] sequence = new BufferOrEvent[]{BarrierBufferAlignmentLimitTest.createBuffer(1, 100), BarrierBufferAlignmentLimitTest.createBuffer(2, 70), BarrierBufferAlignmentLimitTest.createBarrier(3L, 2), BarrierBufferAlignmentLimitTest.createBuffer(1, 100), BarrierBufferAlignmentLimitTest.createBuffer(2, 100), BarrierBufferAlignmentLimitTest.createBarrier(3L, 0), BarrierBufferAlignmentLimitTest.createBuffer(0, 100), BarrierBufferAlignmentLimitTest.createBuffer(1, 100), BarrierBufferAlignmentLimitTest.createBarrier(4L, 0), BarrierBufferAlignmentLimitTest.createBuffer(0, 100), BarrierBufferAlignmentLimitTest.createBuffer(0, 120), BarrierBufferAlignmentLimitTest.createBuffer(1, 100), BarrierBufferAlignmentLimitTest.createBuffer(2, 100), BarrierBufferAlignmentLimitTest.createBarrier(3L, 1), BarrierBufferAlignmentLimitTest.createBarrier(4L, 1), BarrierBufferAlignmentLimitTest.createBuffer(0, 100), BarrierBufferAlignmentLimitTest.createBuffer(1, 100), BarrierBufferAlignmentLimitTest.createBuffer(2, 100), BarrierBufferAlignmentLimitTest.createBarrier(4L, 2), BarrierBufferAlignmentLimitTest.createBuffer(0, 100), BarrierBufferAlignmentLimitTest.createBuffer(1, 100), BarrierBufferAlignmentLimitTest.createBuffer(2, 100)};
        MockInputGate gate = new MockInputGate(512, 3, Arrays.asList(sequence));
        BarrierBuffer buffer = new BarrierBuffer((InputGate)gate, (BufferBlocker)new BufferSpiller(ioManager, gate.getPageSize()), 500L);
        AbstractInvokable toNotify = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        buffer.registerCheckpointEventHandler(toNotify);
        BarrierBufferAlignmentLimitTest.check(sequence[0], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[1], buffer.getNextNonBlocked());
        long startTs = System.nanoTime();
        BarrierBufferAlignmentLimitTest.check(sequence[3], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[7], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[11], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[4], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.validateAlignmentTime(startTs, buffer);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).abortCheckpointOnBarrier(Mockito.eq((long)3L), (Throwable)Mockito.any(AlignmentLimitExceededException.class));
        BarrierBufferAlignmentLimitTest.check(sequence[6], buffer.getNextNonBlocked());
        startTs = System.nanoTime();
        BarrierBufferAlignmentLimitTest.check(sequence[12], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[17], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[9], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.validateAlignmentTime(startTs, buffer);
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)1))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(4L)), (CheckpointOptions)Mockito.any(CheckpointOptions.class), (CheckpointMetrics)Mockito.any(CheckpointMetrics.class));
        BarrierBufferAlignmentLimitTest.check(sequence[10], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[15], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[16], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[19], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[20], buffer.getNextNonBlocked());
        BarrierBufferAlignmentLimitTest.check(sequence[21], buffer.getNextNonBlocked());
        ((AbstractInvokable)Mockito.verify((Object)toNotify, (VerificationMode)Mockito.times((int)0))).triggerCheckpointOnBarrier((CheckpointMetaData)MockitoHamcrest.argThat((Matcher)new CheckpointMatcher(3L)), (CheckpointOptions)Mockito.any(CheckpointOptions.class), (CheckpointMetrics)Mockito.any(CheckpointMetrics.class));
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        Assert.assertNull((Object)buffer.getNextNonBlocked());
        buffer.cleanup();
        BarrierBufferAlignmentLimitTest.checkNoTempFilesRemain();
    }

    private static BufferOrEvent createBuffer(int channel, int size) {
        byte[] bytes = new byte[size];
        RND.nextBytes(bytes);
        MemorySegment memory = MemorySegmentFactory.allocateUnpooledSegment((int)512);
        memory.put(0, bytes);
        NetworkBuffer buf = new NetworkBuffer(memory, FreeingBufferRecycler.INSTANCE);
        buf.setSize(size);
        buf.retainBuffer();
        return new BufferOrEvent((Buffer)buf, channel);
    }

    private static BufferOrEvent createBarrier(long id, int channel) {
        return new BufferOrEvent((AbstractEvent)new CheckpointBarrier(id, System.currentTimeMillis(), CheckpointOptions.forCheckpointWithDefaultLocation()), channel);
    }

    private static void check(BufferOrEvent expected, BufferOrEvent present) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)present);
        Assert.assertEquals((Object)expected.isBuffer(), (Object)present.isBuffer());
        if (expected.isBuffer()) {
            Assert.assertEquals((long)expected.getBuffer().getMaxCapacity(), (long)present.getBuffer().getMaxCapacity());
            Assert.assertEquals((long)expected.getBuffer().getSize(), (long)present.getBuffer().getSize());
            MemorySegment expectedMem = expected.getBuffer().getMemorySegment();
            MemorySegment presentMem = present.getBuffer().getMemorySegment();
            Assert.assertTrue((String)"memory contents differs", (expectedMem.compare(presentMem, 0, 0, 512) == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((Object)expected.getEvent(), (Object)present.getEvent());
        }
    }

    private static void validateAlignmentTime(long startTimestamp, BarrierBuffer buffer) {
        long elapsed = System.nanoTime() - startTimestamp;
        Assert.assertTrue((String)"wrong alignment time", (buffer.getAlignmentDurationNanos() <= elapsed ? 1 : 0) != 0);
    }

    private static void checkNoTempFilesRemain() {
        for (File dir : ioManager.getSpillingDirectories()) {
            for (String file : dir.list()) {
                if (file == null || file.equals(".") || file.equals("..")) continue;
                Assert.fail((String)("barrier buffer did not clean up temp files. remaining file: " + file));
            }
        }
    }

    private static class CheckpointMatcher
    extends BaseMatcher<CheckpointMetaData> {
        private final long checkpointId;

        CheckpointMatcher(long checkpointId) {
            this.checkpointId = checkpointId;
        }

        public boolean matches(Object o) {
            return o != null && o.getClass() == CheckpointMetaData.class && ((CheckpointMetaData)o).getCheckpointId() == this.checkpointId;
        }

        public void describeTo(Description description) {
            description.appendText("CheckpointMetaData - id = " + this.checkpointId);
        }
    }
}

