/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.operators.StreamGroupedReduce;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.junit.Assert;
import org.junit.Test;

public class StreamGroupedReduceTest {
    private static TypeInformation<Integer> typeInfo = BasicTypeInfo.INT_TYPE_INFO;

    @Test
    public void testGroupedReduce() throws Exception {
        IntegerKeySelector keySelector = new IntegerKeySelector();
        StreamGroupedReduce operator = new StreamGroupedReduce((ReduceFunction)new MyReducer(), (TypeSerializer)IntSerializer.INSTANCE);
        KeyedOneInputStreamOperatorTestHarness testHarness = new KeyedOneInputStreamOperatorTestHarness(operator, keySelector, (TypeInformation<Integer>)BasicTypeInfo.INT_TYPE_INFO);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)1, initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)1, initialTime + 2L));
        testHarness.processWatermark(new Watermark(initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)2, initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)2, initialTime + 4L));
        testHarness.processElement(new StreamRecord((Object)3, initialTime + 5L));
        expectedOutput.add(new StreamRecord((Object)1, initialTime + 1L));
        expectedOutput.add(new StreamRecord((Object)2, initialTime + 2L));
        expectedOutput.add(new Watermark(initialTime + 2L));
        expectedOutput.add(new StreamRecord((Object)2, initialTime + 3L));
        expectedOutput.add(new StreamRecord((Object)4, initialTime + 4L));
        expectedOutput.add(new StreamRecord((Object)3, initialTime + 5L));
        TestHarnessUtil.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testOpenClose() throws Exception {
        IntegerKeySelector keySelector = new IntegerKeySelector();
        StreamGroupedReduce operator = new StreamGroupedReduce((ReduceFunction)new TestOpenCloseReduceFunction(), (TypeSerializer)IntSerializer.INSTANCE);
        KeyedOneInputStreamOperatorTestHarness testHarness = new KeyedOneInputStreamOperatorTestHarness(operator, keySelector, (TypeInformation<Integer>)BasicTypeInfo.INT_TYPE_INFO);
        long initialTime = 0L;
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)1, initialTime));
        testHarness.processElement(new StreamRecord((Object)2, initialTime));
        testHarness.close();
        Assert.assertTrue((String)"RichFunction methods where not called.", (boolean)TestOpenCloseReduceFunction.closeCalled);
        Assert.assertTrue((String)"Output contains no elements.", (testHarness.getOutput().size() > 0 ? 1 : 0) != 0);
    }

    private static class IntegerKeySelector
    implements KeySelector<Integer, Integer> {
        private static final long serialVersionUID = 1L;

        private IntegerKeySelector() {
        }

        public Integer getKey(Integer value) throws Exception {
            return value;
        }
    }

    private static class MyReducer
    implements ReduceFunction<Integer> {
        private static final long serialVersionUID = 1L;

        private MyReducer() {
        }

        public Integer reduce(Integer value1, Integer value2) throws Exception {
            return value1 + value2;
        }
    }

    private static class TestOpenCloseReduceFunction
    extends RichReduceFunction<Integer> {
        private static final long serialVersionUID = 1L;
        public static boolean openCalled = false;
        public static boolean closeCalled = false;

        private TestOpenCloseReduceFunction() {
        }

        public void open(Configuration parameters) throws Exception {
            super.open(parameters);
            if (closeCalled) {
                Assert.fail((String)"Close called before open.");
            }
            openCalled = true;
        }

        public void close() throws Exception {
            super.close();
            if (!openCalled) {
                Assert.fail((String)"Open was not called before close.");
            }
            closeCalled = true;
        }

        public Integer reduce(Integer in1, Integer in2) throws Exception {
            if (!openCalled) {
                Assert.fail((String)"Open was not called before run.");
            }
            return in1 + in2;
        }
    }
}

