/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class GetOperatorUniqueIDTest
extends TestLogger {
    @Test
    public void testGetOperatorUniqueID() throws Exception {
        LocalStreamEnvironment env = StreamExecutionEnvironment.createLocalEnvironment();
        env.fromElements((Object[])new Integer[]{1, 2, 3}).map((MapFunction)new VerifyOperatorIDMapFunction("6c4f323f22da8fb6e34f80c61be7a689")).uid("42").map((MapFunction)new VerifyOperatorIDMapFunction("3e129e83691e7737fbf876b47452acbc")).uid("44");
        env.execute();
    }

    private static class VerifyOperatorIDMapFunction
    extends AbstractRichFunction
    implements MapFunction<Integer, Integer> {
        private static final long serialVersionUID = 6584823409744624276L;
        private final String expectedOperatorUniqueID;

        public VerifyOperatorIDMapFunction(String expectedOperatorUniqueID) {
            this.expectedOperatorUniqueID = (String)Preconditions.checkNotNull((Object)expectedOperatorUniqueID);
        }

        public void open(Configuration parameters) throws Exception {
            super.open(parameters);
            Assert.assertEquals((Object)this.expectedOperatorUniqueID, (Object)((StreamingRuntimeContext)this.getRuntimeContext()).getOperatorUniqueID());
        }

        public Integer map(Integer value) throws Exception {
            return value;
        }
    }
}

