/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.File;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.api.functions.sink.filesystem.TestUtils;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LocalStreamingFileSinkTest
extends TestLogger {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();

    @Test
    public void testClosingWithoutInput() throws Exception {
        File outDir = TEMP_FOLDER.newFolder();
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 124L);){
            testHarness.setup();
            testHarness.open();
        }
    }

    @Test
    public void testClosingWithoutInitializingStateShouldNotFail() throws Exception {
        File outDir = TEMP_FOLDER.newFolder();
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 124L);){
            testHarness.setup();
        }
    }

    @Test
    public void testTruncateAfterRecoveryAndOverwrite() throws Exception {
        OperatorSubtaskState snapshot;
        File outDir = TEMP_FOLDER.newFolder();
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 10L);){
            testHarness.setup();
            testHarness.open();
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)1), 1L));
            TestUtils.checkLocalFs(outDir, 1, 0);
            snapshot = testHarness.snapshot(1L, 1L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)2), 2L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)3), 3L));
            TestUtils.checkLocalFs(outDir, 2, 0);
            Map<File, String> contents = TestUtils.getFileContentByPath(outDir);
            int fileCounter = 0;
            for (Map.Entry<File, String> fileContents : contents.entrySet()) {
                if (fileContents.getKey().getName().contains(".part-0-0.inprogress")) {
                    ++fileCounter;
                    Assert.assertEquals((Object)"test1@1\ntest1@2\n", (Object)fileContents.getValue());
                    continue;
                }
                if (!fileContents.getKey().getName().contains(".part-0-1.inprogress")) continue;
                ++fileCounter;
                Assert.assertEquals((Object)"test1@3\n", (Object)fileContents.getValue());
            }
            Assert.assertEquals((long)2L, (long)fileCounter);
        }
        testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 10L);
        var4_3 = null;
        try {
            testHarness.setup();
            testHarness.initializeState(snapshot);
            testHarness.open();
            TestUtils.checkLocalFs(outDir, 2, 0);
            int fileCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getName().contains(".part-0-0.inprogress")) {
                    ++fileCounter;
                    Assert.assertEquals((Object)"test1@1\n", (Object)fileContents.getValue());
                    continue;
                }
                if (!fileContents.getKey().getName().contains(".part-0-1.inprogress")) continue;
                ++fileCounter;
                Assert.assertEquals((Object)"test1@3\n", (Object)fileContents.getValue());
            }
            Assert.assertEquals((long)2L, (long)fileCounter);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)4), 4L));
            fileCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getName().contains(".part-0-0.inprogress")) {
                    ++fileCounter;
                    Assert.assertEquals((Object)"test1@1\ntest1@4\n", (Object)fileContents.getValue());
                    continue;
                }
                if (!fileContents.getKey().getName().contains(".part-0-1.inprogress")) continue;
                ++fileCounter;
                Assert.assertEquals((Object)"test1@3\n", (Object)fileContents.getValue());
            }
            Assert.assertEquals((long)2L, (long)fileCounter);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)5), 5L));
            TestUtils.checkLocalFs(outDir, 3, 0);
            testHarness.snapshot(2L, 2L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)6), 6L));
            TestUtils.checkLocalFs(outDir, 3, 0);
            fileCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getName().contains(".part-0-0.inprogress")) {
                    ++fileCounter;
                    Assert.assertEquals((Object)"test1@1\ntest1@4\n", (Object)fileContents.getValue());
                    continue;
                }
                if (!fileContents.getKey().getName().contains(".part-0-1.inprogress") || !fileContents.getValue().equals("test1@5\ntest1@6\n") && !fileContents.getValue().equals("test1@3\n")) continue;
                ++fileCounter;
            }
            Assert.assertEquals((long)3L, (long)fileCounter);
            testHarness.notifyOfCompletedCheckpoint(2L);
            TestUtils.checkLocalFs(outDir, 2, 1);
            fileCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getName().equals("part-0-0")) {
                    ++fileCounter;
                    Assert.assertEquals((Object)"test1@1\ntest1@4\n", (Object)fileContents.getValue());
                    continue;
                }
                if (!fileContents.getKey().getName().contains(".part-0-1.inprogress") || !fileContents.getValue().equals("test1@5\ntest1@6\n") && !fileContents.getValue().equals("test1@3\n")) continue;
                ++fileCounter;
            }
            Assert.assertEquals((long)3L, (long)fileCounter);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (testHarness != null) {
                if (var4_3 != null) {
                    try {
                        testHarness.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    testHarness.close();
                }
            }
        }
    }

    @Test
    public void testCommitStagedFilesInCorrectOrder() throws Exception {
        File outDir = TEMP_FOLDER.newFolder();
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 10L);){
            testHarness.setup();
            testHarness.open();
            testHarness.setProcessingTime(0L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)1), 1L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)2), 2L));
            TestUtils.checkLocalFs(outDir, 1, 0);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)3), 3L));
            TestUtils.checkLocalFs(outDir, 2, 0);
            testHarness.snapshot(1L, 1L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)4), 4L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)5), 5L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)6), 6L));
            TestUtils.checkLocalFs(outDir, 3, 0);
            testHarness.snapshot(2L, 2L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)7), 7L));
            TestUtils.checkLocalFs(outDir, 4, 0);
            testHarness.setProcessingTime(101L);
            testHarness.snapshot(3L, 3L);
            testHarness.notifyOfCompletedCheckpoint(1L);
            TestUtils.checkLocalFs(outDir, 3, 1);
            int fileCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getName().equals("part-0-0")) {
                    ++fileCounter;
                    Assert.assertEquals((Object)"test1@1\ntest1@2\n", (Object)fileContents.getValue());
                    continue;
                }
                if (fileContents.getKey().getName().contains(".part-0-1.inprogress")) {
                    ++fileCounter;
                    Assert.assertEquals((Object)"test1@3\ntest1@4\n", (Object)fileContents.getValue());
                    continue;
                }
                if (fileContents.getKey().getName().contains(".part-0-2.inprogress")) {
                    ++fileCounter;
                    Assert.assertEquals((Object)"test1@5\ntest1@6\n", (Object)fileContents.getValue());
                    continue;
                }
                if (!fileContents.getKey().getName().contains(".part-0-3.inprogress")) continue;
                ++fileCounter;
                Assert.assertEquals((Object)"test1@7\n", (Object)fileContents.getValue());
            }
            Assert.assertEquals((long)4L, (long)fileCounter);
            testHarness.notifyOfCompletedCheckpoint(3L);
            TestUtils.checkLocalFs(outDir, 0, 4);
            fileCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getName().equals("part-0-0")) {
                    ++fileCounter;
                    Assert.assertEquals((Object)"test1@1\ntest1@2\n", (Object)fileContents.getValue());
                    continue;
                }
                if (fileContents.getKey().getName().equals("part-0-1")) {
                    ++fileCounter;
                    Assert.assertEquals((Object)"test1@3\ntest1@4\n", (Object)fileContents.getValue());
                    continue;
                }
                if (fileContents.getKey().getName().equals("part-0-2")) {
                    ++fileCounter;
                    Assert.assertEquals((Object)"test1@5\ntest1@6\n", (Object)fileContents.getValue());
                    continue;
                }
                if (!fileContents.getKey().getName().equals("part-0-3")) continue;
                ++fileCounter;
                Assert.assertEquals((Object)"test1@7\n", (Object)fileContents.getValue());
            }
            Assert.assertEquals((long)4L, (long)fileCounter);
        }
    }

    @Test
    public void testInactivityPeriodWithLateNotify() throws Exception {
        File outDir = TEMP_FOLDER.newFolder();
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 124L);){
            testHarness.setup();
            testHarness.open();
            testHarness.setProcessingTime(0L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)1), 1L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test2", (Object)1), 1L));
            TestUtils.checkLocalFs(outDir, 2, 0);
            int bucketCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getParentFile().getName().equals("test1")) {
                    ++bucketCounter;
                    continue;
                }
                if (!fileContents.getKey().getParentFile().getName().equals("test2")) continue;
                ++bucketCounter;
            }
            Assert.assertEquals((long)2L, (long)bucketCounter);
            testHarness.setProcessingTime(101L);
            TestUtils.checkLocalFs(outDir, 2, 0);
            testHarness.snapshot(0L, 0L);
            TestUtils.checkLocalFs(outDir, 2, 0);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test3", (Object)1), 1L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test4", (Object)1), 1L));
            testHarness.setProcessingTime(202L);
            testHarness.snapshot(1L, 0L);
            TestUtils.checkLocalFs(outDir, 4, 0);
            testHarness.notifyOfCompletedCheckpoint(0L);
            TestUtils.checkLocalFs(outDir, 2, 2);
            bucketCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getParentFile().getName().equals("test1")) {
                    ++bucketCounter;
                    Assert.assertEquals((Object)"part-0-0", (Object)fileContents.getKey().getName());
                    Assert.assertEquals((Object)"test1@1\n", (Object)fileContents.getValue());
                    continue;
                }
                if (fileContents.getKey().getParentFile().getName().equals("test2")) {
                    ++bucketCounter;
                    Assert.assertEquals((Object)"part-0-1", (Object)fileContents.getKey().getName());
                    Assert.assertEquals((Object)"test2@1\n", (Object)fileContents.getValue());
                    continue;
                }
                if (fileContents.getKey().getParentFile().getName().equals("test3")) {
                    ++bucketCounter;
                    continue;
                }
                if (!fileContents.getKey().getParentFile().getName().equals("test4")) continue;
                ++bucketCounter;
            }
            Assert.assertEquals((long)4L, (long)bucketCounter);
            testHarness.notifyOfCompletedCheckpoint(1L);
            TestUtils.checkLocalFs(outDir, 0, 4);
            bucketCounter = 0;
            for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                if (fileContents.getKey().getParentFile().getName().equals("test1")) {
                    ++bucketCounter;
                    Assert.assertEquals((Object)"test1@1\n", (Object)fileContents.getValue());
                    continue;
                }
                if (fileContents.getKey().getParentFile().getName().equals("test2")) {
                    ++bucketCounter;
                    Assert.assertEquals((Object)"test2@1\n", (Object)fileContents.getValue());
                    continue;
                }
                if (fileContents.getKey().getParentFile().getName().equals("test3")) {
                    ++bucketCounter;
                    Assert.assertEquals((Object)"part-0-2", (Object)fileContents.getKey().getName());
                    Assert.assertEquals((Object)"test3@1\n", (Object)fileContents.getValue());
                    continue;
                }
                if (!fileContents.getKey().getParentFile().getName().equals("test4")) continue;
                ++bucketCounter;
                Assert.assertEquals((Object)"part-0-3", (Object)fileContents.getKey().getName());
                Assert.assertEquals((Object)"test4@1\n", (Object)fileContents.getValue());
            }
            Assert.assertEquals((long)4L, (long)bucketCounter);
        }
    }

    @Test
    public void testClosingOnSnapshot() throws Exception {
        File outDir = TEMP_FOLDER.newFolder();
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 2L);){
            testHarness.setup();
            testHarness.open();
            testHarness.setProcessingTime(0L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)1), 1L));
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test2", (Object)1), 1L));
            TestUtils.checkLocalFs(outDir, 2, 0);
            testHarness.setProcessingTime(101L);
            TestUtils.checkLocalFs(outDir, 2, 0);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test3", (Object)1), 1L));
            TestUtils.checkLocalFs(outDir, 3, 0);
            testHarness.snapshot(0L, 1L);
            TestUtils.checkLocalFs(outDir, 3, 0);
            testHarness.notifyOfCompletedCheckpoint(0L);
            TestUtils.checkLocalFs(outDir, 0, 3);
            testHarness.snapshot(1L, 0L);
            testHarness.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test4", (Object)10), 10L));
            TestUtils.checkLocalFs(outDir, 1, 3);
        }
        TestUtils.checkLocalFs(outDir, 1, 3);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testScalingDownAndMergingOfStates() throws Exception {
        OperatorSubtaskState mergedSnapshot;
        File outDir = TEMP_FOLDER.newFolder();
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness1 = TestUtils.createRescalingTestSink(outDir, 2, 0, 100L, 10L);){
            OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness2 = TestUtils.createRescalingTestSink(outDir, 2, 1, 100L, 10L);
            Object object = null;
            try {
                void var7_12;
                testHarness1.setup();
                testHarness1.open();
                testHarness2.setup();
                testHarness2.open();
                testHarness1.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)0), 0L));
                TestUtils.checkLocalFs(outDir, 1, 0);
                testHarness2.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test1", (Object)1), 1L));
                testHarness2.processElement((StreamRecord<Tuple2<String, Integer>>)new StreamRecord((Object)Tuple2.of((Object)"test2", (Object)1), 1L));
                TestUtils.checkLocalFs(outDir, 3, 0);
                boolean bl = false;
                for (Map.Entry<File, String> fileContents : TestUtils.getFileContentByPath(outDir).entrySet()) {
                    String parentFilename = fileContents.getKey().getParentFile().getName();
                    String inProgressFilename = fileContents.getKey().getName();
                    if (parentFilename.equals("test1") && (inProgressFilename.contains(".part-0-0.inprogress") || inProgressFilename.contains(".part-1-0.inprogress"))) {
                        ++var7_12;
                        continue;
                    }
                    if (!parentFilename.equals("test2") || !inProgressFilename.contains(".part-1-1.inprogress")) continue;
                    ++var7_12;
                }
                Assert.assertEquals((long)3L, (long)((long)var7_12));
                mergedSnapshot = AbstractStreamOperatorTestHarness.repackageState(testHarness1.snapshot(1L, 0L), testHarness2.snapshot(1L, 0L));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (testHarness2 != null) {
                    if (object != null) {
                        try {
                            testHarness2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        testHarness2.close();
                    }
                }
            }
        }
        var4_3 = null;
        try (OneInputStreamOperatorTestHarness<Tuple2<String, Integer>, Object> testHarness = TestUtils.createRescalingTestSink(outDir, 1, 0, 100L, 10L);){
            testHarness.setup();
            testHarness.initializeState(mergedSnapshot);
            testHarness.open();
            TestUtils.checkLocalFs(outDir, 3, 0);
            testHarness.snapshot(2L, 2L);
            testHarness.notifyOfCompletedCheckpoint(2L);
            int counter = 0;
            for (Map.Entry entry : TestUtils.getFileContentByPath(outDir).entrySet()) {
                String parentFilename = ((File)entry.getKey()).getParentFile().getName();
                String filename = ((File)entry.getKey()).getName();
                if (parentFilename.equals("test1")) {
                    if (!filename.contains("-0.inprogress") && !filename.endsWith("-0")) continue;
                    ++counter;
                    Assert.assertTrue((((String)entry.getValue()).equals("test1@1\n") || ((String)entry.getValue()).equals("test1@0\n") ? 1 : 0) != 0);
                    continue;
                }
                if (!parentFilename.equals("test2") || !filename.contains(".part-1-1.inprogress")) continue;
                ++counter;
                Assert.assertEquals((Object)"test2@1\n", entry.getValue());
            }
            Assert.assertEquals((long)3L, (long)counter);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }
}

