/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.File;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.sink.filesystem.Bucket;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketFactory;
import org.apache.flink.streaming.api.functions.sink.filesystem.Buckets;
import org.apache.flink.streaming.api.functions.sink.filesystem.DefaultBucketFactoryImpl;
import org.apache.flink.streaming.api.functions.sink.filesystem.PartFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.RowWisePartWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.TestUtils;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.BasePathBucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BucketAssignerITCases {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();

    @Test
    public void testAssembleBucketPath() throws Exception {
        File outDir = TEMP_FOLDER.newFolder();
        Path basePath = new Path(outDir.toURI());
        long time = 1000L;
        DefaultRollingPolicy rollingPolicy = DefaultRollingPolicy.create().withMaxPartSize(7L).build();
        Buckets buckets = new Buckets(basePath, (BucketAssigner)new BasePathBucketAssigner(), (BucketFactory)new DefaultBucketFactoryImpl(), (PartFileWriter.PartFileFactory)new RowWisePartWriter.Factory((Encoder)new SimpleStringEncoder()), (RollingPolicy)rollingPolicy, 0);
        Bucket bucket = buckets.onElement((Object)"abc", (SinkFunction.Context)new TestUtils.MockSinkContext(1000L, 1000L, 1000L));
        Assert.assertEquals((Object)new Path(basePath.toUri()), (Object)bucket.getBucketPath());
    }
}

