/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.testutils.MiniClusterResource;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamUtils;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class RemoteStreamExecutionEnvironmentTest
extends TestLogger {
    @ClassRule
    public static final MiniClusterResource MINI_CLUSTER_RESOURCE = new MiniClusterResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(1).build());

    @Test
    public void testPortForwarding() throws Exception {
        Configuration clientConfiguration = new Configuration();
        clientConfiguration.setInteger(RestOptions.RETRY_MAX_ATTEMPTS, 0);
        MiniCluster miniCluster = MINI_CLUSTER_RESOURCE.getMiniCluster();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.createRemoteEnvironment((String)miniCluster.getRestAddress().getHost(), (int)miniCluster.getRestAddress().getPort(), (Configuration)clientConfiguration, (String[])new String[0]);
        SingleOutputStreamOperator resultStream = env.fromElements((Object[])new Integer[]{1}).map((MapFunction & Serializable)x -> x * 2);
        Iterator result = DataStreamUtils.collect((DataStream)resultStream);
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((long)2L, (long)((Integer)result.next()).intValue());
        Assert.assertFalse((boolean)result.hasNext());
    }
}

