/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.util.Collections;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;
import org.junit.Assert;
import org.junit.Test;

public class SplitSideOutputTest {
    private static final OutputTag<String> outputTag = new OutputTag<String>("outputTag"){};

    @Test
    public void testSideOutputAfterSelectIsForbidden() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SingleOutputStreamOperator processInput = env.fromElements((Object[])new String[]{"foo"}).process((ProcessFunction)new DummyProcessFunction());
        processInput.split(Collections::singleton);
        try {
            processInput.getSideOutput(outputTag);
            Assert.fail((String)"Should have failed early with an exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testSelectAfterSideOutputIsForbidden() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SingleOutputStreamOperator processInput = env.fromElements((Object[])new String[]{"foo"}).process((ProcessFunction)new DummyProcessFunction());
        processInput.getSideOutput(outputTag);
        try {
            processInput.split(Collections::singleton);
            Assert.fail((String)"Should have failed early with an exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static final class DummyProcessFunction
    extends ProcessFunction<String, String> {
        private DummyProcessFunction() {
        }

        public void processElement(String value, ProcessFunction.Context ctx, Collector<String> out) throws Exception {
        }
    }
}

