/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.SimpleVersionedStringSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class DateTimeBucketAssigner<IN>
implements BucketAssigner<IN, String> {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_FORMAT_STRING = "yyyy-MM-dd--HH";
    private final String formatString;
    private final ZoneId zoneId;
    private transient DateTimeFormatter dateTimeFormatter;

    public DateTimeBucketAssigner() {
        this(DEFAULT_FORMAT_STRING);
    }

    public DateTimeBucketAssigner(String formatString) {
        this(formatString, ZoneId.systemDefault());
    }

    public DateTimeBucketAssigner(ZoneId zoneId) {
        this(DEFAULT_FORMAT_STRING, zoneId);
    }

    public DateTimeBucketAssigner(String formatString, ZoneId zoneId) {
        this.formatString = (String)Preconditions.checkNotNull((Object)formatString);
        this.zoneId = (ZoneId)Preconditions.checkNotNull((Object)zoneId);
    }

    @Override
    public String getBucketId(IN element, BucketAssigner.Context context) {
        if (this.dateTimeFormatter == null) {
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.formatString).withZone(this.zoneId);
        }
        return this.dateTimeFormatter.format(Instant.ofEpochMilli(context.currentProcessingTime()));
    }

    @Override
    public SimpleVersionedSerializer<String> getSerializer() {
        return SimpleVersionedStringSerializer.INSTANCE;
    }

    public String toString() {
        return "DateTimeBucketAssigner{formatString='" + this.formatString + '\'' + ", zoneId=" + this.zoneId + '}';
    }
}

