/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;

@PublicEvolving
public final class LatencyMarker
extends StreamElement {
    private final long markedTime;
    private final int vertexID;
    private final int subtaskIndex;

    public LatencyMarker(long markedTime, int vertexID, int subtaskIndex) {
        this.markedTime = markedTime;
        this.vertexID = vertexID;
        this.subtaskIndex = subtaskIndex;
    }

    public long getMarkedTime() {
        return this.markedTime;
    }

    public int getVertexID() {
        return this.vertexID;
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatencyMarker that = (LatencyMarker)o;
        if (this.markedTime != that.markedTime) {
            return false;
        }
        if (this.vertexID != that.vertexID) {
            return false;
        }
        return this.subtaskIndex == that.subtaskIndex;
    }

    public int hashCode() {
        int result = (int)(this.markedTime ^ this.markedTime >>> 32);
        result = 31 * result + this.vertexID;
        result = 31 * result + this.subtaskIndex;
        return result;
    }

    public String toString() {
        return "LatencyMarker{markedTime=" + this.markedTime + ", vertexID=" + this.vertexID + ", subtaskIndex=" + this.subtaskIndex + '}';
    }
}

