/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.RunnableFuture;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.util.ExceptionUtils;

public class OperatorSnapshotResult {
    private RunnableFuture<KeyedStateHandle> keyedStateManagedFuture;
    private RunnableFuture<KeyedStateHandle> keyedStateRawFuture;
    private RunnableFuture<OperatorStateHandle> operatorStateManagedFuture;
    private RunnableFuture<OperatorStateHandle> operatorStateRawFuture;

    public OperatorSnapshotResult() {
        this(null, null, null, null);
    }

    public OperatorSnapshotResult(RunnableFuture<KeyedStateHandle> keyedStateManagedFuture, RunnableFuture<KeyedStateHandle> keyedStateRawFuture, RunnableFuture<OperatorStateHandle> operatorStateManagedFuture, RunnableFuture<OperatorStateHandle> operatorStateRawFuture) {
        this.keyedStateManagedFuture = keyedStateManagedFuture;
        this.keyedStateRawFuture = keyedStateRawFuture;
        this.operatorStateManagedFuture = operatorStateManagedFuture;
        this.operatorStateRawFuture = operatorStateRawFuture;
    }

    public RunnableFuture<KeyedStateHandle> getKeyedStateManagedFuture() {
        return this.keyedStateManagedFuture;
    }

    public void setKeyedStateManagedFuture(RunnableFuture<KeyedStateHandle> keyedStateManagedFuture) {
        this.keyedStateManagedFuture = keyedStateManagedFuture;
    }

    public RunnableFuture<KeyedStateHandle> getKeyedStateRawFuture() {
        return this.keyedStateRawFuture;
    }

    public void setKeyedStateRawFuture(RunnableFuture<KeyedStateHandle> keyedStateRawFuture) {
        this.keyedStateRawFuture = keyedStateRawFuture;
    }

    public RunnableFuture<OperatorStateHandle> getOperatorStateManagedFuture() {
        return this.operatorStateManagedFuture;
    }

    public void setOperatorStateManagedFuture(RunnableFuture<OperatorStateHandle> operatorStateManagedFuture) {
        this.operatorStateManagedFuture = operatorStateManagedFuture;
    }

    public RunnableFuture<OperatorStateHandle> getOperatorStateRawFuture() {
        return this.operatorStateRawFuture;
    }

    public void setOperatorStateRawFuture(RunnableFuture<OperatorStateHandle> operatorStateRawFuture) {
        this.operatorStateRawFuture = operatorStateRawFuture;
    }

    public void cancel() throws Exception {
        Exception exception = null;
        try {
            StateUtil.discardStateFuture(this.getKeyedStateManagedFuture());
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)new Exception("Could not properly cancel managed keyed state future.", e), exception);
        }
        try {
            StateUtil.discardStateFuture(this.getOperatorStateManagedFuture());
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)new Exception("Could not properly cancel managed operator state future.", e), (Throwable)exception);
        }
        try {
            StateUtil.discardStateFuture(this.getKeyedStateRawFuture());
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)new Exception("Could not properly cancel raw keyed state future.", e), (Throwable)exception);
        }
        try {
            StateUtil.discardStateFuture(this.getOperatorStateRawFuture());
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)new Exception("Could not properly cancel raw operator state future.", e), (Throwable)exception);
        }
        if (exception != null) {
            throw exception;
        }
    }

    public boolean hasKeyedState() {
        return this.keyedStateManagedFuture != null || this.keyedStateRawFuture != null;
    }

    public boolean hasOperatorState() {
        return this.operatorStateManagedFuture != null || this.operatorStateRawFuture != null;
    }

    public boolean hasState() {
        return this.hasKeyedState() || this.hasOperatorState();
    }
}

