/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.windowing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.api.functions.windowing.InternalProcessApplyAllWindowContext;
import org.apache.flink.streaming.api.functions.windowing.ProcessAllWindowFunction;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;

@Deprecated
@Internal
public class FoldApplyProcessAllWindowFunction<W extends Window, T, ACC, R>
extends ProcessAllWindowFunction<T, R, W>
implements OutputTypeConfigurable<R> {
    private static final long serialVersionUID = 1L;
    private final FoldFunction<T, ACC> foldFunction;
    private final ProcessAllWindowFunction<ACC, R, W> windowFunction;
    private byte[] serializedInitialValue;
    private TypeSerializer<ACC> accSerializer;
    private final TypeInformation<ACC> accTypeInformation;
    private transient ACC initialValue;
    private transient InternalProcessApplyAllWindowContext<ACC, R, W> ctx;

    public FoldApplyProcessAllWindowFunction(ACC initialValue, FoldFunction<T, ACC> foldFunction, ProcessAllWindowFunction<ACC, R, W> windowFunction, TypeInformation<ACC> accTypeInformation) {
        this.windowFunction = windowFunction;
        this.foldFunction = foldFunction;
        this.initialValue = initialValue;
        this.accTypeInformation = accTypeInformation;
    }

    public void open(Configuration configuration) throws Exception {
        FunctionUtils.openFunction(this.windowFunction, (Configuration)configuration);
        if (this.serializedInitialValue == null) {
            throw new RuntimeException("No initial value was serialized for the fold window function. Probably the setOutputType method was not called.");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.serializedInitialValue);
        DataInputViewStreamWrapper in = new DataInputViewStreamWrapper((InputStream)bais);
        this.initialValue = this.accSerializer.deserialize((DataInputView)in);
        this.ctx = new InternalProcessApplyAllWindowContext<ACC, R, W>(this.windowFunction);
    }

    public void close() throws Exception {
        FunctionUtils.closeFunction(this.windowFunction);
    }

    public void setRuntimeContext(RuntimeContext t) {
        super.setRuntimeContext(t);
        FunctionUtils.setFunctionRuntimeContext(this.windowFunction, (RuntimeContext)t);
    }

    @Override
    public void process(ProcessAllWindowFunction.Context context, Iterable<T> values, Collector<R> out) throws Exception {
        Object result = this.accSerializer.copy(this.initialValue);
        for (T val : values) {
            result = this.foldFunction.fold(result, val);
        }
        this.ctx.window = context.window();
        this.ctx.windowState = context.windowState();
        this.ctx.globalState = context.globalState();
        this.windowFunction.process(this.ctx, Collections.singletonList(result), out);
    }

    @Override
    public void clear(ProcessAllWindowFunction.Context context) throws Exception {
        this.ctx.window = context.window();
        this.ctx.windowState = context.windowState();
        this.ctx.globalState = context.globalState();
        this.windowFunction.clear(this.ctx);
    }

    @Override
    public void setOutputType(TypeInformation<R> outTypeInfo, ExecutionConfig executionConfig) {
        this.accSerializer = this.accTypeInformation.createSerializer(executionConfig);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper((OutputStream)baos);
        try {
            this.accSerializer.serialize(this.initialValue, (DataOutputView)out);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to serialize initial value of type " + this.initialValue.getClass().getSimpleName() + " of fold window function.", ioe);
        }
        this.serializedInitialValue = baos.toByteArray();
    }
}

