/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.functions.sink.WriteFormat;

@PublicEvolving
public class WriteFormatAsCsv<IN>
extends WriteFormat<IN> {
    private static final long serialVersionUID = 1L;

    @Override
    protected void write(String path, ArrayList<IN> tupleList) {
        try (PrintWriter outStream = new PrintWriter(new BufferedWriter(new FileWriter(path, true)));){
            for (IN tupleToWrite : tupleList) {
                String strTuple = tupleToWrite.toString();
                outStream.println(strTuple.substring(1, strTuple.length() - 1));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception occured while writing file " + path, e);
        }
    }
}

