/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.operators.testutils.MockInputSplitProvider;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.mockito.Mockito;

public class TwoInputStreamOperatorTestHarness<IN1, IN2, OUT> {
    TwoInputStreamOperator<IN1, IN2, OUT> operator;
    final ConcurrentLinkedQueue<Object> outputList;
    final ExecutionConfig executionConfig;
    final Object checkpointLock;

    public TwoInputStreamOperatorTestHarness(TwoInputStreamOperator<IN1, IN2, OUT> operator) {
        this(operator, new StreamConfig(new Configuration()));
    }

    public TwoInputStreamOperatorTestHarness(TwoInputStreamOperator<IN1, IN2, OUT> operator, StreamConfig config) {
        this.operator = operator;
        this.outputList = new ConcurrentLinkedQueue();
        this.executionConfig = new ExecutionConfig();
        this.checkpointLock = new Object();
        MockEnvironment env = new MockEnvironment("MockTwoInputTask", 0x300000L, new MockInputSplitProvider(), 1024);
        StreamTask mockTask = (StreamTask)Mockito.mock(StreamTask.class);
        Mockito.when((Object)mockTask.getName()).thenReturn((Object)"Mock Task");
        Mockito.when((Object)mockTask.getCheckpointLock()).thenReturn(this.checkpointLock);
        Mockito.when((Object)mockTask.getConfiguration()).thenReturn((Object)config);
        Mockito.when((Object)mockTask.getEnvironment()).thenReturn((Object)env);
        Mockito.when((Object)mockTask.getExecutionConfig()).thenReturn((Object)this.executionConfig);
        operator.setup(mockTask, new StreamConfig(new Configuration()), (Output)new MockOutput());
    }

    public ConcurrentLinkedQueue<Object> getOutput() {
        return this.outputList;
    }

    public void open() throws Exception {
        this.operator.open();
    }

    public void close() throws Exception {
        this.operator.close();
    }

    public void processElement1(StreamRecord<IN1> element) throws Exception {
        this.operator.processElement1(element);
    }

    public void processElement2(StreamRecord<IN2> element) throws Exception {
        this.operator.processElement2(element);
    }

    public void processWatermark1(Watermark mark) throws Exception {
        this.operator.processWatermark1(mark);
    }

    public void processWatermark2(Watermark mark) throws Exception {
        this.operator.processWatermark2(mark);
    }

    private class MockOutput
    implements Output<StreamRecord<OUT>> {
        private TypeSerializer<OUT> outputSerializer;

        private MockOutput() {
        }

        public void emitWatermark(Watermark mark) {
            TwoInputStreamOperatorTestHarness.this.outputList.add(mark);
        }

        public void collect(StreamRecord<OUT> element) {
            if (this.outputSerializer == null) {
                this.outputSerializer = TypeExtractor.getForObject((Object)element.getValue()).createSerializer(TwoInputStreamOperatorTestHarness.this.executionConfig);
            }
            TwoInputStreamOperatorTestHarness.this.outputList.add(new StreamRecord(this.outputSerializer.copy(element.getValue()), element.getTimestamp()));
        }

        public void close() {
        }
    }
}

