/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;

public class TestHarnessUtil {
    public static <OUT> List<StreamRecord<OUT>> getStreamRecordsFromOutput(List<Object> output) {
        LinkedList<StreamRecord<OUT>> resultElements = new LinkedList<StreamRecord<OUT>>();
        for (Object e : output) {
            if (!(e instanceof StreamRecord)) continue;
            resultElements.add((StreamRecord)e);
        }
        return resultElements;
    }

    public static <OUT> List<OUT> getRawElementsFromOutput(Queue<Object> output) {
        LinkedList<Object> resultElements = new LinkedList<Object>();
        for (Object e : output) {
            if (!(e instanceof StreamRecord)) continue;
            resultElements.add(((StreamRecord)e).getValue());
        }
        return resultElements;
    }

    public static void assertOutputEquals(String message, Queue<Object> expected, Queue<Object> actual) {
        Assert.assertArrayEquals((String)message, (Object[])expected.toArray(), (Object[])actual.toArray());
    }

    public static void assertOutputEqualsSorted(String message, Queue<Object> expected, Queue<Object> actual, Comparator<Object> comparator) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Iterator exIt = expected.iterator();
        Iterator actIt = actual.iterator();
        while (exIt.hasNext()) {
            Object nextEx = exIt.next();
            Object nextAct = actIt.next();
            if (!(nextEx instanceof Watermark)) continue;
            Assert.assertEquals(nextEx, nextAct);
        }
        ArrayList expectedRecords = new ArrayList();
        ArrayList actualRecords = new ArrayList();
        for (Object e : expected) {
            if (!(e instanceof StreamRecord)) continue;
            expectedRecords.add(e);
        }
        for (Object e : actual) {
            if (!(e instanceof StreamRecord)) continue;
            actualRecords.add(e);
        }
        Object[] sortedExpected = expectedRecords.toArray();
        Object[] objectArray = actualRecords.toArray();
        Arrays.sort(sortedExpected, comparator);
        Arrays.sort(objectArray, comparator);
        Assert.assertArrayEquals((String)message, (Object[])sortedExpected, (Object[])objectArray);
    }
}

