/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.util.HDFSCopyFromLocal;
import org.apache.flink.streaming.util.HDFSCopyToLocal;
import org.apache.flink.util.OperatingSystem;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HDFSCopyUtilitiesTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Before
    public void checkOperatingSystem() {
        Assume.assumeTrue((String)"This test can't run successfully on Windows.", (!OperatingSystem.isWindows() ? 1 : 0) != 0);
    }

    @Test
    public void testCopyFromLocal() throws Exception {
        File testFolder = this.tempFolder.newFolder();
        File originalFile = new File(testFolder, "original");
        File copyFile = new File(testFolder, "copy");
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(originalFile));){
            out.writeUTF("Hello there, 42!");
        }
        HDFSCopyFromLocal.copyFromLocal((File)originalFile, (URI)new Path("file://" + copyFile.getAbsolutePath()).toUri());
        var5_5 = null;
        try (DataInputStream in = new DataInputStream(new FileInputStream(copyFile));){
            Assert.assertTrue((boolean)in.readUTF().equals("Hello there, 42!"));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testCopyToLocal() throws Exception {
        File testFolder = this.tempFolder.newFolder();
        File originalFile = new File(testFolder, "original");
        File copyFile = new File(testFolder, "copy");
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(originalFile));){
            out.writeUTF("Hello there, 42!");
        }
        HDFSCopyToLocal.copyToLocal((URI)new Path("file://" + originalFile.getAbsolutePath()).toUri(), (File)copyFile);
        var5_5 = null;
        try (DataInputStream in = new DataInputStream(new FileInputStream(copyFile));){
            Assert.assertTrue((boolean)in.readUTF().equals("Hello there, 42!"));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }
}

