/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.streaming.util.FieldAccessor;
import org.junit.Assert;
import org.junit.Test;

public class FieldAccessorTest {
    @Test
    public void arrayFieldAccessorTest() {
        int[] a = new int[]{3, 5};
        FieldAccessor fieldAccessor = FieldAccessor.create((int)1, (TypeInformation)PrimitiveArrayTypeInfo.getInfoFor(a.getClass()), null);
        Assert.assertEquals(Integer.class, (Object)fieldAccessor.getFieldType().getTypeClass());
        Assert.assertEquals((Object)a[1], (Object)fieldAccessor.get((Object)a));
        a = (int[])fieldAccessor.set((Object)a, (Object)6);
        Assert.assertEquals((Object)a[1], (Object)fieldAccessor.get((Object)a));
        Integer[] b = new Integer[]{3, 5};
        FieldAccessor fieldAccessor2 = FieldAccessor.create((int)1, (TypeInformation)BasicArrayTypeInfo.getInfoFor(b.getClass()), null);
        Assert.assertEquals(Integer.class, (Object)fieldAccessor2.getFieldType().getTypeClass());
        Assert.assertEquals((Object)b[1], (Object)fieldAccessor2.get((Object)b));
        b = (Integer[])fieldAccessor2.set((Object)b, (Object)6);
        Assert.assertEquals((Object)b[1], (Object)fieldAccessor2.get((Object)b));
    }

    @Test
    public void tupleFieldAccessorOutOfBoundsTest() {
        try {
            FieldAccessor fieldAccessor = FieldAccessor.create((int)2, (TypeInformation)TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, Integer.class}), null);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

