/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.util.DataInputDeserializer;
import org.apache.flink.runtime.util.DataOutputSerializer;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.MultiplexingStreamRecordSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MultiplexingStreamRecordSerializerTest {
    @Test
    public void testDeepDuplication() {
        TypeSerializer serializer1 = (TypeSerializer)Mockito.mock(TypeSerializer.class);
        TypeSerializer serializer2 = (TypeSerializer)Mockito.mock(TypeSerializer.class);
        Mockito.when((Object)serializer1.duplicate()).thenReturn((Object)serializer2);
        MultiplexingStreamRecordSerializer streamRecSer = new MultiplexingStreamRecordSerializer(serializer1);
        Assert.assertEquals((Object)serializer1, (Object)streamRecSer.getContainedTypeSerializer());
        MultiplexingStreamRecordSerializer copy = streamRecSer.duplicate();
        Assert.assertNotEquals((Object)copy, (Object)streamRecSer);
        Assert.assertNotEquals((Object)copy.getContainedTypeSerializer(), (Object)streamRecSer.getContainedTypeSerializer());
    }

    @Test
    public void testBasicProperties() {
        MultiplexingStreamRecordSerializer streamRecSer = new MultiplexingStreamRecordSerializer((TypeSerializer)LongSerializer.INSTANCE);
        Assert.assertFalse((boolean)streamRecSer.isImmutableType());
        Assert.assertEquals(Long.class, ((Long)streamRecSer.createInstance().getValue()).getClass());
        Assert.assertEquals((long)-1L, (long)streamRecSer.getLength());
    }

    @Test
    public void testSerialization() throws Exception {
        MultiplexingStreamRecordSerializer serializer = new MultiplexingStreamRecordSerializer((TypeSerializer)StringSerializer.INSTANCE);
        StreamRecord withoutTimestamp = new StreamRecord((Object)"test 1 2 \u5206\u4eab\u57fa\u7763\u8036\u7a4c\u7684\u611b\u7d66\u5011\uff0c\u958b\u62d3\u96d9\u8d0f!");
        Assert.assertEquals((Object)withoutTimestamp, (Object)MultiplexingStreamRecordSerializerTest.serializeAndDeserialize(withoutTimestamp, serializer));
        StreamRecord withTimestamp = new StreamRecord((Object)"one more test \u62d3 \u5011 \u5206", 77L);
        Assert.assertEquals((Object)withTimestamp, (Object)MultiplexingStreamRecordSerializerTest.serializeAndDeserialize(withTimestamp, serializer));
        StreamRecord negativeTimestamp = new StreamRecord((Object)"\u4ed6", Long.MIN_VALUE);
        Assert.assertEquals((Object)negativeTimestamp, (Object)MultiplexingStreamRecordSerializerTest.serializeAndDeserialize(negativeTimestamp, serializer));
        Watermark positiveWatermark = new Watermark(13L);
        Assert.assertEquals((Object)positiveWatermark, (Object)MultiplexingStreamRecordSerializerTest.serializeAndDeserialize(positiveWatermark, serializer));
        Watermark negativeWatermark = new Watermark(-4647654567676555876L);
        Assert.assertEquals((Object)negativeWatermark, (Object)MultiplexingStreamRecordSerializerTest.serializeAndDeserialize(negativeWatermark, serializer));
    }

    private static <T, X extends StreamElement> X serializeAndDeserialize(X record, MultiplexingStreamRecordSerializer<T> serializer) throws IOException {
        DataOutputSerializer output = new DataOutputSerializer(32);
        serializer.serialize(record, (DataOutputView)output);
        DataInputDeserializer copyInput = new DataInputDeserializer(output.getByteArray(), 0, output.length());
        DataOutputSerializer copyOutput = new DataOutputSerializer(32);
        serializer.copy((DataInputView)copyInput, (DataOutputView)copyOutput);
        DataInputDeserializer input = new DataInputDeserializer(copyOutput.getByteArray(), 0, copyOutput.length());
        return (X)serializer.deserialize((DataInputView)input);
    }
}

