/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.streamtask;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.tasks.StreamIterationHead;
import org.apache.flink.streaming.runtime.tasks.StreamTaskTestHarness;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ResultPartitionWriter.class})
@PowerMockIgnore(value={"javax.management.*", "com.sun.jndi.*"})
public class StreamIterationHeadTest {
    @Test
    public void testIterationHeadWatermarkEmission() throws Exception {
        StreamIterationHead head = new StreamIterationHead();
        StreamTaskTestHarness harness = new StreamTaskTestHarness((AbstractInvokable)head, BasicTypeInfo.INT_TYPE_INFO);
        harness.getStreamConfig().setIterationId("1");
        harness.getStreamConfig().setIterationWaitTime(1L);
        harness.invoke();
        harness.waitForTaskCompletion();
        Assert.assertEquals((long)1L, (long)harness.getOutput().size());
        Assert.assertEquals((Object)new Watermark(Long.MAX_VALUE), (Object)harness.getOutput().peek());
    }
}

