/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.windowing.functions;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.windowing.AllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.RichAllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.RichWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalIterableAllWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalIterableWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalSingleValueAllWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalSingleValueWindowFunction;
import org.apache.flink.util.Collector;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Test;
import org.mockito.Mockito;

public class InternalWindowFunctionTest {
    @Test
    public void testInternalIterableAllWindowFunction() throws Exception {
        AllWindowFunctionMock mock = (AllWindowFunctionMock)((Object)Mockito.mock(AllWindowFunctionMock.class));
        InternalIterableAllWindowFunction windowFunction = new InternalIterableAllWindowFunction((AllWindowFunction)mock);
        BasicTypeInfo stringType = BasicTypeInfo.STRING_TYPE_INFO;
        ExecutionConfig execConf = new ExecutionConfig();
        execConf.setParallelism(42);
        windowFunction.setOutputType((TypeInformation)stringType, execConf);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setOutputType((TypeInformation<String>)stringType, execConf);
        Configuration config = new Configuration();
        windowFunction.open(config);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).open(config);
        RuntimeContext rCtx = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        windowFunction.setRuntimeContext(rCtx);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setRuntimeContext(rCtx);
        TimeWindow w = (TimeWindow)Mockito.mock(TimeWindow.class);
        Iterable i = (Iterable)Mockito.mock(Iterable.class);
        Collector c = (Collector)Mockito.mock(Collector.class);
        windowFunction.apply(Byte.valueOf((byte)0), (Window)w, i, c);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).apply(w, (Iterable<Long>)i, (Collector<String>)c);
        windowFunction.close();
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).close();
    }

    @Test
    public void testInternalIterableWindowFunction() throws Exception {
        WindowFunctionMock mock = (WindowFunctionMock)((Object)Mockito.mock(WindowFunctionMock.class));
        InternalIterableWindowFunction windowFunction = new InternalIterableWindowFunction((WindowFunction)mock);
        BasicTypeInfo stringType = BasicTypeInfo.STRING_TYPE_INFO;
        ExecutionConfig execConf = new ExecutionConfig();
        execConf.setParallelism(42);
        windowFunction.setOutputType((TypeInformation)stringType, execConf);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setOutputType((TypeInformation<String>)stringType, execConf);
        Configuration config = new Configuration();
        windowFunction.open(config);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).open(config);
        RuntimeContext rCtx = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        windowFunction.setRuntimeContext(rCtx);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setRuntimeContext(rCtx);
        TimeWindow w = (TimeWindow)Mockito.mock(TimeWindow.class);
        Iterable i = (Iterable)Mockito.mock(Iterable.class);
        Collector c = (Collector)Mockito.mock(Collector.class);
        windowFunction.apply((Object)42L, (Window)w, i, c);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).apply(42L, w, (Iterable<Long>)i, (Collector<String>)c);
        windowFunction.close();
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).close();
    }

    @Test
    public void testInternalSingleValueWindowFunction() throws Exception {
        WindowFunctionMock mock = (WindowFunctionMock)((Object)Mockito.mock(WindowFunctionMock.class));
        InternalSingleValueWindowFunction windowFunction = new InternalSingleValueWindowFunction((WindowFunction)mock);
        BasicTypeInfo stringType = BasicTypeInfo.STRING_TYPE_INFO;
        ExecutionConfig execConf = new ExecutionConfig();
        execConf.setParallelism(42);
        windowFunction.setOutputType((TypeInformation)stringType, execConf);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setOutputType((TypeInformation<String>)stringType, execConf);
        Configuration config = new Configuration();
        windowFunction.open(config);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).open(config);
        RuntimeContext rCtx = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        windowFunction.setRuntimeContext(rCtx);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setRuntimeContext(rCtx);
        TimeWindow w = (TimeWindow)Mockito.mock(TimeWindow.class);
        Collector c = (Collector)Mockito.mock(Collector.class);
        windowFunction.apply((Object)42L, (Window)w, (Object)23L, c);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).apply(Mockito.eq((long)42L), (TimeWindow)Mockito.eq((Object)w), (Iterable<Long>)((Iterable)Mockito.argThat((Matcher)IsIterableContainingInOrder.contains((Object[])new Long[]{23L}))), (Collector<String>)((Collector)Mockito.eq((Object)c)));
        windowFunction.close();
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).close();
    }

    @Test
    public void testInternalSingleValueAllWindowFunction() throws Exception {
        AllWindowFunctionMock mock = (AllWindowFunctionMock)((Object)Mockito.mock(AllWindowFunctionMock.class));
        InternalSingleValueAllWindowFunction windowFunction = new InternalSingleValueAllWindowFunction((AllWindowFunction)mock);
        BasicTypeInfo stringType = BasicTypeInfo.STRING_TYPE_INFO;
        ExecutionConfig execConf = new ExecutionConfig();
        execConf.setParallelism(42);
        windowFunction.setOutputType((TypeInformation)stringType, execConf);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setOutputType((TypeInformation<String>)stringType, execConf);
        Configuration config = new Configuration();
        windowFunction.open(config);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).open(config);
        RuntimeContext rCtx = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        windowFunction.setRuntimeContext(rCtx);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setRuntimeContext(rCtx);
        TimeWindow w = (TimeWindow)Mockito.mock(TimeWindow.class);
        Collector c = (Collector)Mockito.mock(Collector.class);
        windowFunction.apply(Byte.valueOf((byte)0), (Window)w, (Object)23L, c);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).apply((TimeWindow)Mockito.eq((Object)w), (Iterable<Long>)((Iterable)Mockito.argThat((Matcher)IsIterableContainingInOrder.contains((Object[])new Long[]{23L}))), (Collector<String>)((Collector)Mockito.eq((Object)c)));
        windowFunction.close();
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).close();
    }

    public static class AllWindowFunctionMock
    extends RichAllWindowFunction<Long, String, TimeWindow>
    implements OutputTypeConfigurable<String> {
        public void setOutputType(TypeInformation<String> outTypeInfo, ExecutionConfig executionConfig) {
        }

        public void apply(TimeWindow window, Iterable<Long> values, Collector<String> out) throws Exception {
        }
    }

    public static class WindowFunctionMock
    extends RichWindowFunction<Long, String, Long, TimeWindow>
    implements OutputTypeConfigurable<String> {
        public void setOutputType(TypeInformation<String> outTypeInfo, ExecutionConfig executionConfig) {
        }

        public void apply(Long aLong, TimeWindow window, Iterable<Long> input, Collector<String> out) throws Exception {
        }
    }
}

