/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.operators.StreamFlatMap;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class StreamFlatMapTest {
    @Test
    public void testFlatMap() throws Exception {
        StreamFlatMap operator = new StreamFlatMap((FlatMapFunction)new MyFlatMap());
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(operator);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)1, initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)2, initialTime + 2L));
        testHarness.processWatermark(new Watermark(initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)3, initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)4, initialTime + 4L));
        testHarness.processElement(new StreamRecord((Object)5, initialTime + 5L));
        testHarness.processElement(new StreamRecord((Object)6, initialTime + 6L));
        testHarness.processElement(new StreamRecord((Object)7, initialTime + 7L));
        testHarness.processElement(new StreamRecord((Object)8, initialTime + 8L));
        expectedOutput.add(new StreamRecord((Object)2, initialTime + 2L));
        expectedOutput.add(new StreamRecord((Object)4, initialTime + 2L));
        expectedOutput.add(new Watermark(initialTime + 2L));
        expectedOutput.add(new StreamRecord((Object)4, initialTime + 4L));
        expectedOutput.add(new StreamRecord((Object)16, initialTime + 4L));
        expectedOutput.add(new StreamRecord((Object)6, initialTime + 6L));
        expectedOutput.add(new StreamRecord((Object)36, initialTime + 6L));
        expectedOutput.add(new StreamRecord((Object)8, initialTime + 8L));
        expectedOutput.add(new StreamRecord((Object)64, initialTime + 8L));
        TestHarnessUtil.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testOpenClose() throws Exception {
        StreamFlatMap operator = new StreamFlatMap((FlatMapFunction)new TestOpenCloseFlatMapFunction());
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(operator);
        long initialTime = 0L;
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)"Hello", initialTime));
        testHarness.close();
        Assert.assertTrue((String)"RichFunction methods where not called.", (boolean)TestOpenCloseFlatMapFunction.closeCalled);
        Assert.assertTrue((String)"Output contains no elements.", (testHarness.getOutput().size() > 0 ? 1 : 0) != 0);
    }

    private static class TestOpenCloseFlatMapFunction
    extends RichFlatMapFunction<String, String> {
        private static final long serialVersionUID = 1L;
        public static boolean openCalled = false;
        public static boolean closeCalled = false;

        private TestOpenCloseFlatMapFunction() {
        }

        public void open(Configuration parameters) throws Exception {
            super.open(parameters);
            if (closeCalled) {
                Assert.fail((String)"Close called before open.");
            }
            openCalled = true;
        }

        public void close() throws Exception {
            super.close();
            if (!openCalled) {
                Assert.fail((String)"Open was not called before close.");
            }
            closeCalled = true;
        }

        public void flatMap(String value, Collector<String> out) throws Exception {
            if (!openCalled) {
                Assert.fail((String)"Open was not called before run.");
            }
            out.collect((Object)value);
        }
    }

    public static final class MyFlatMap
    implements FlatMapFunction<Integer, Integer> {
        private static final long serialVersionUID = 1L;

        public void flatMap(Integer value, Collector<Integer> out) throws Exception {
            if (value % 2 == 0) {
                out.collect((Object)value);
                out.collect((Object)(value * value));
            }
        }
    }
}

