/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions;

import org.apache.flink.streaming.api.functions.timestamps.AscendingTimestampExtractor;
import org.junit.Assert;
import org.junit.Test;

public class AscendingTimestampExtractorTest {
    @Test
    public void testWithFailingHandler() {
        AscendingTimestampExtractor extractor = new LongExtractor().withViolationHandler((AscendingTimestampExtractor.MonotonyViolationHandler)new AscendingTimestampExtractor.FailingHandler());
        this.runValidTests((AscendingTimestampExtractor<Long>)extractor);
        try {
            this.runInvalidTest((AscendingTimestampExtractor<Long>)extractor);
            Assert.fail((String)"should fail with an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testWithIgnoringHandler() {
        AscendingTimestampExtractor extractor = new LongExtractor().withViolationHandler((AscendingTimestampExtractor.MonotonyViolationHandler)new AscendingTimestampExtractor.IgnoringHandler());
        this.runValidTests((AscendingTimestampExtractor<Long>)extractor);
        this.runInvalidTest((AscendingTimestampExtractor<Long>)extractor);
    }

    @Test
    public void testWithLoggingHandler() {
        AscendingTimestampExtractor extractor = new LongExtractor().withViolationHandler((AscendingTimestampExtractor.MonotonyViolationHandler)new AscendingTimestampExtractor.LoggingHandler());
        this.runValidTests((AscendingTimestampExtractor<Long>)extractor);
        this.runInvalidTest((AscendingTimestampExtractor<Long>)extractor);
    }

    @Test
    public void testWithDefaultHandler() {
        LongExtractor extractor = new LongExtractor();
        this.runValidTests(extractor);
        this.runInvalidTest(extractor);
    }

    @Test
    public void testInitialAndFinalWatermark() {
        LongExtractor extractor = new LongExtractor();
        Assert.assertEquals((long)Long.MIN_VALUE, (long)extractor.getCurrentWatermark().getTimestamp());
        extractor.extractTimestamp(Long.MIN_VALUE, -1L);
        extractor.extractTimestamp(Long.MAX_VALUE, -1L);
        Assert.assertEquals((long)0x7FFFFFFFFFFFFFFEL, (long)extractor.getCurrentWatermark().getTimestamp());
    }

    private void runValidTests(AscendingTimestampExtractor<Long> extractor) {
        Assert.assertEquals((long)13L, (long)extractor.extractTimestamp((Object)13L, -1L));
        Assert.assertEquals((long)13L, (long)extractor.extractTimestamp((Object)13L, 0L));
        Assert.assertEquals((long)14L, (long)extractor.extractTimestamp((Object)14L, 0L));
        Assert.assertEquals((long)20L, (long)extractor.extractTimestamp((Object)20L, 0L));
        Assert.assertEquals((long)20L, (long)extractor.extractTimestamp((Object)20L, 0L));
        Assert.assertEquals((long)20L, (long)extractor.extractTimestamp((Object)20L, 0L));
        Assert.assertEquals((long)500L, (long)extractor.extractTimestamp((Object)500L, 0L));
        Assert.assertEquals((long)0x7FFFFFFFFFFFFFFEL, (long)extractor.extractTimestamp((Object)0x7FFFFFFFFFFFFFFEL, 99999L));
    }

    private void runInvalidTest(AscendingTimestampExtractor<Long> extractor) {
        Assert.assertEquals((long)1000L, (long)extractor.extractTimestamp((Object)1000L, 100L));
        Assert.assertEquals((long)1000L, (long)extractor.extractTimestamp((Object)1000L, 100L));
        Assert.assertEquals((long)999L, (long)extractor.extractTimestamp((Object)999L, 100L));
    }

    private static class LongExtractor
    extends AscendingTimestampExtractor<Long> {
        private static final long serialVersionUID = 1L;

        private LongExtractor() {
        }

        public long extractAscendingTimestamp(Long element) {
            return element;
        }
    }
}

