/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.junit.Assert;
import org.junit.Test;

public class RestartStrategyTest {
    @Test
    public void testAutomaticRestartingWhenCheckpointing() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.enableCheckpointing(500L);
        env.fromElements((Object[])new Integer[]{1}).print();
        StreamGraph graph = env.getStreamGraph();
        JobGraph jobGraph = graph.getJobGraph();
        RestartStrategies.RestartStrategyConfiguration restartStrategy = ((ExecutionConfig)jobGraph.getSerializedExecutionConfig().deserializeValue(this.getClass().getClassLoader())).getRestartStrategy();
        Assert.assertNotNull((Object)restartStrategy);
        Assert.assertTrue((boolean)(restartStrategy instanceof RestartStrategies.FixedDelayRestartStrategyConfiguration));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)((RestartStrategies.FixedDelayRestartStrategyConfiguration)restartStrategy).getRestartAttempts());
    }

    @Test
    public void testNoRestartingWhenCheckpointingAndExplicitExecutionRetriesZero() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.enableCheckpointing(500L);
        env.setNumberOfExecutionRetries(0);
        env.fromElements((Object[])new Integer[]{1}).print();
        StreamGraph graph = env.getStreamGraph();
        JobGraph jobGraph = graph.getJobGraph();
        RestartStrategies.RestartStrategyConfiguration restartStrategy = ((ExecutionConfig)jobGraph.getSerializedExecutionConfig().deserializeValue(this.getClass().getClassLoader())).getRestartStrategy();
        Assert.assertNotNull((Object)restartStrategy);
        Assert.assertTrue((boolean)(restartStrategy instanceof RestartStrategies.NoRestartStrategyConfiguration));
    }

    @Test
    public void testFixedRestartingWhenCheckpointingAndExplicitExecutionRetriesNonZero() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.enableCheckpointing(500L);
        env.setNumberOfExecutionRetries(42);
        env.getConfig().setExecutionRetryDelay(1337L);
        env.fromElements((Object[])new Integer[]{1}).print();
        StreamGraph graph = env.getStreamGraph();
        JobGraph jobGraph = graph.getJobGraph();
        RestartStrategies.RestartStrategyConfiguration restartStrategy = ((ExecutionConfig)jobGraph.getSerializedExecutionConfig().deserializeValue(this.getClass().getClassLoader())).getRestartStrategy();
        Assert.assertNotNull((Object)restartStrategy);
        Assert.assertTrue((boolean)(restartStrategy instanceof RestartStrategies.FixedDelayRestartStrategyConfiguration));
        Assert.assertEquals((long)42L, (long)((RestartStrategies.FixedDelayRestartStrategyConfiguration)restartStrategy).getRestartAttempts());
        Assert.assertEquals((long)1337L, (long)((RestartStrategies.FixedDelayRestartStrategyConfiguration)restartStrategy).getDelayBetweenAttemptsInterval().toMilliseconds());
    }
}

