/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public final class StreamRecordSerializer<T>
extends TypeSerializer<StreamRecord<T>> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<T> typeSerializer;

    public StreamRecordSerializer(TypeSerializer<T> serializer) {
        if (serializer instanceof StreamRecordSerializer) {
            throw new RuntimeException("StreamRecordSerializer given to StreamRecordSerializer as value TypeSerializer: " + serializer);
        }
        this.typeSerializer = Preconditions.checkNotNull(serializer);
    }

    public TypeSerializer<T> getContainedTypeSerializer() {
        return this.typeSerializer;
    }

    public StreamRecordSerializer<T> duplicate() {
        TypeSerializer serializerCopy = this.typeSerializer.duplicate();
        return serializerCopy == this.typeSerializer ? this : new StreamRecordSerializer<T>(serializerCopy);
    }

    public boolean isImmutableType() {
        return false;
    }

    public int getLength() {
        return this.typeSerializer.getLength();
    }

    public StreamRecord<T> createInstance() {
        try {
            return new StreamRecord<Object>(this.typeSerializer.createInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate StreamRecord.", e);
        }
    }

    public StreamRecord<T> copy(StreamRecord<T> from) {
        return from.copy(this.typeSerializer.copy(from.getValue()));
    }

    public StreamRecord<T> copy(StreamRecord<T> from, StreamRecord<T> reuse) {
        from.copyTo(this.typeSerializer.copy(from.getValue(), reuse.getValue()), reuse);
        return reuse;
    }

    public void serialize(StreamRecord<T> value, DataOutputView target) throws IOException {
        this.typeSerializer.serialize(value.getValue(), target);
    }

    public StreamRecord<T> deserialize(DataInputView source) throws IOException {
        return new StreamRecord<Object>(this.typeSerializer.deserialize(source));
    }

    public StreamRecord<T> deserialize(StreamRecord<T> reuse, DataInputView source) throws IOException {
        Object element = this.typeSerializer.deserialize(reuse.getValue(), source);
        reuse.replace(element);
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.typeSerializer.copy(source, target);
    }

    public boolean equals(Object obj) {
        if (obj instanceof StreamRecordSerializer) {
            StreamRecordSerializer other = (StreamRecordSerializer)((Object)obj);
            return other.canEqual((Object)this) && this.typeSerializer.equals(other.typeSerializer);
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof StreamRecordSerializer;
    }

    public int hashCode() {
        return this.typeSerializer.hashCode();
    }
}

