/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.Collection;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.MergingState;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.com.google.common.base.Function;
import org.apache.flink.shaded.com.google.common.collect.FluentIterable;
import org.apache.flink.shaded.com.google.common.collect.Iterables;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalWindowFunction;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class EvictingWindowOperator<K, IN, OUT, W extends Window>
extends WindowOperator<K, IN, Iterable<IN>, OUT, W> {
    private static final long serialVersionUID = 1L;
    private final Evictor<? super IN, ? super W> evictor;
    private final StateDescriptor<? extends ListState<StreamRecord<IN>>, ?> windowStateDescriptor;

    public EvictingWindowOperator(WindowAssigner<? super IN, W> windowAssigner, TypeSerializer<W> windowSerializer, KeySelector<IN, K> keySelector, TypeSerializer<K> keySerializer, StateDescriptor<? extends ListState<StreamRecord<IN>>, ?> windowStateDescriptor, InternalWindowFunction<Iterable<IN>, OUT, K, W> windowFunction, Trigger<? super IN, ? super W> trigger, Evictor<? super IN, ? super W> evictor) {
        super(windowAssigner, windowSerializer, keySelector, keySerializer, null, windowFunction, trigger);
        this.evictor = Objects.requireNonNull(evictor);
        this.windowStateDescriptor = windowStateDescriptor;
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        Collection elementWindows = this.windowAssigner.assignWindows(element.getValue(), element.getTimestamp());
        Object key = this.getStateBackend().getCurrentKey();
        for (Window window : elementWindows) {
            ListState<StreamRecord<IN>> windowState = this.getPartitionedState(window, this.windowSerializer, this.windowStateDescriptor);
            windowState.add(element);
            this.context.key = key;
            this.context.window = window;
            TriggerResult triggerResult = this.context.onElement(element);
            this.processTriggerResult(triggerResult, key, window);
        }
    }

    @Override
    protected void processTriggerResult(TriggerResult triggerResult, K key, W window) throws Exception {
        if (!triggerResult.isFire() && !triggerResult.isPurge()) {
            return;
        }
        if (triggerResult.isFire()) {
            this.timestampedCollector.setAbsoluteTimestamp(((Window)window).maxTimestamp());
            this.setKeyContext(key);
            ListState<StreamRecord<IN>> windowState = this.getPartitionedState(window, this.windowSerializer, this.windowStateDescriptor);
            Iterable contents = (Iterable)windowState.get();
            int toEvict = this.evictor.evict(contents, Iterables.size(contents), this.context.window);
            FluentIterable projectedContents = FluentIterable.from(contents).skip(toEvict).transform(new Function<StreamRecord<IN>, IN>(){

                @Override
                public IN apply(StreamRecord<IN> input) {
                    return input.getValue();
                }
            });
            ((InternalWindowFunction)this.userFunction).apply(this.context.key, this.context.window, projectedContents, this.timestampedCollector);
            if (triggerResult.isPurge()) {
                windowState.clear();
            } else {
                windowState.clear();
                for (StreamRecord rec : FluentIterable.from(contents).skip(toEvict)) {
                    windowState.add((Object)rec);
                }
            }
        } else if (triggerResult.isPurge()) {
            this.setKeyContext(key);
            ListState<StreamRecord<IN>> windowState = this.getPartitionedState(window, this.windowSerializer, this.windowStateDescriptor);
            windowState.clear();
        }
    }

    @VisibleForTesting
    public Evictor<? super IN, ? super W> getEvictor() {
        return this.evictor;
    }

    @Override
    @VisibleForTesting
    public StateDescriptor<? extends MergingState<IN, Iterable<IN>>, ?> getStateDescriptor() {
        return this.windowStateDescriptor;
    }
}

