/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink;

import java.io.PrintStream;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;

@PublicEvolving
public class PrintSinkFunction<IN>
extends RichSinkFunction<IN> {
    private static final long serialVersionUID = 1L;
    private static final boolean STD_OUT = false;
    private static final boolean STD_ERR = true;
    private boolean target;
    private transient PrintStream stream;
    private transient String prefix;

    public PrintSinkFunction() {
    }

    public PrintSinkFunction(boolean stdErr) {
        this.target = stdErr;
    }

    public void setTargetToStandardOut() {
        this.target = false;
    }

    public void setTargetToStandardErr() {
        this.target = true;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        StreamingRuntimeContext context = (StreamingRuntimeContext)this.getRuntimeContext();
        this.stream = !this.target ? System.out : System.err;
        this.prefix = context.getNumberOfParallelSubtasks() > 1 ? context.getIndexOfThisSubtask() + 1 + "> " : null;
    }

    @Override
    public void invoke(IN record) {
        if (this.prefix != null) {
            this.stream.println(this.prefix + record.toString());
        } else {
            this.stream.println(record.toString());
        }
    }

    public void close() {
        this.stream = null;
        this.prefix = null;
    }

    public String toString() {
        return "Print to " + (!this.target ? "System.out" : "System.err");
    }
}

