/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.CleanupWhenUnsuccessful;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class OutputFormatSinkFunction<IN>
extends RichSinkFunction<IN>
implements InputTypeConfigurable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(OutputFormatSinkFunction.class);
    private OutputFormat<IN> format;
    private boolean cleanupCalled = false;

    public OutputFormatSinkFunction(OutputFormat<IN> format) {
        this.format = format;
    }

    public void open(Configuration parameters) throws Exception {
        RuntimeContext context = this.getRuntimeContext();
        this.format.configure(parameters);
        int indexInSubtaskGroup = context.getIndexOfThisSubtask();
        int currentNumberOfSubtasks = context.getNumberOfParallelSubtasks();
        this.format.open(indexInSubtaskGroup, currentNumberOfSubtasks);
    }

    public void setInputType(TypeInformation<?> type, ExecutionConfig executionConfig) {
        if (this.format instanceof InputTypeConfigurable) {
            InputTypeConfigurable itc = (InputTypeConfigurable)this.format;
            itc.setInputType(type, executionConfig);
        }
    }

    @Override
    public void invoke(IN record) throws Exception {
        try {
            this.format.writeRecord(record);
        }
        catch (Exception ex) {
            this.cleanup();
            throw ex;
        }
    }

    public void close() throws IOException {
        try {
            this.format.close();
        }
        catch (Exception ex) {
            this.cleanup();
            throw ex;
        }
    }

    private void cleanup() {
        try {
            if (!this.cleanupCalled && this.format instanceof CleanupWhenUnsuccessful) {
                this.cleanupCalled = true;
                ((CleanupWhenUnsuccessful)this.format).tryCleanupOnError();
            }
        }
        catch (Throwable t) {
            LOG.error("Cleanup on error failed.", t);
        }
    }
}

