/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import org.apache.flink.streaming.runtime.streamrecord.StreamElement;

public class StreamRecord<T>
extends StreamElement {
    private T value;
    private long timestamp;

    public StreamRecord(T value) {
        this(value, -9223372036854775807L);
    }

    public StreamRecord(T value, long timestamp) {
        this.value = value;
        this.timestamp = timestamp;
    }

    public T getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public <X> StreamRecord<X> replace(X element) {
        this.value = element;
        return this;
    }

    public <X> StreamRecord<X> replace(X value, long timestamp) {
        this.timestamp = timestamp;
        this.value = value;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamRecord that = (StreamRecord)o;
        return this.value.equals(that.value) && this.timestamp == that.timestamp;
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String toString() {
        return "Record{" + this.value + "; " + this.timestamp + '}';
    }
}

