/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.streaming.api.functions.windowing.AllWindowFunction;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.NonKeyedWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.buffers.EvictingWindowBuffer;
import org.apache.flink.streaming.runtime.operators.windowing.buffers.WindowBufferFactory;

public class EvictingNonKeyedWindowOperator<IN, OUT, W extends Window>
extends NonKeyedWindowOperator<IN, OUT, W> {
    private static final long serialVersionUID = 1L;
    private final Evictor<? super IN, ? super W> evictor;

    public EvictingNonKeyedWindowOperator(WindowAssigner<? super IN, W> windowAssigner, TypeSerializer<W> windowSerializer, WindowBufferFactory<? super IN, ? extends EvictingWindowBuffer<IN>> windowBufferFactory, AllWindowFunction<IN, OUT, W> windowFunction, Trigger<? super IN, ? super W> trigger, Evictor<? super IN, ? super W> evictor) {
        super(windowAssigner, windowSerializer, windowBufferFactory, windowFunction, trigger);
        this.evictor = Objects.requireNonNull(evictor);
    }

    @Override
    protected void emitWindow(NonKeyedWindowOperator.Context context) throws Exception {
        this.timestampedCollector.setTimestamp(((Window)context.window).maxTimestamp());
        EvictingWindowBuffer windowBuffer = (EvictingWindowBuffer)context.windowBuffer;
        int toEvict = 0;
        if (windowBuffer.size() > 0) {
            toEvict = this.evictor.evict(windowBuffer.getElements(), windowBuffer.size(), context.window);
        }
        windowBuffer.removeElements(toEvict);
        ((AllWindowFunction)this.userFunction).apply(context.window, context.windowBuffer.getUnpackedElements(), this.timestampedCollector);
    }

    @Override
    public EvictingNonKeyedWindowOperator<IN, OUT, W> enableSetProcessingTime(boolean setProcessingTime) {
        super.enableSetProcessingTime(setProcessingTime);
        return this;
    }

    @VisibleForTesting
    public Evictor<? super IN, ? super W> getEvictor() {
        return this.evictor;
    }
}

