/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators;

import org.apache.flink.streaming.api.functions.TimestampExtractor;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.operators.Triggerable;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class ExtractTimestampsOperator<T>
extends AbstractUdfStreamOperator<T, TimestampExtractor<T>>
implements OneInputStreamOperator<T, T>,
Triggerable {
    private static final long serialVersionUID = 1L;
    transient long watermarkInterval;
    transient long currentWatermark;

    public ExtractTimestampsOperator(TimestampExtractor<T> extractor) {
        super(extractor);
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.watermarkInterval = this.getExecutionConfig().getAutoWatermarkInterval();
        if (this.watermarkInterval > 0L) {
            this.registerTimer(System.currentTimeMillis() + this.watermarkInterval, this);
        }
        this.currentWatermark = Long.MIN_VALUE;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.output.emitWatermark(new Watermark(Long.MAX_VALUE));
    }

    @Override
    public void processElement(StreamRecord<T> element) throws Exception {
        long newTimestamp = ((TimestampExtractor)this.userFunction).extractTimestamp(element.getValue(), element.getTimestamp());
        this.output.collect(element.replace(element.getValue(), newTimestamp));
        long watermark = ((TimestampExtractor)this.userFunction).extractWatermark(element.getValue(), newTimestamp);
        if (watermark > this.currentWatermark) {
            this.currentWatermark = watermark;
            this.output.emitWatermark(new Watermark(this.currentWatermark));
        }
    }

    @Override
    public void trigger(long timestamp) throws Exception {
        this.registerTimer(System.currentTimeMillis() + this.watermarkInterval, this);
        long lastWatermark = this.currentWatermark;
        this.currentWatermark = ((TimestampExtractor)this.userFunction).getCurrentWatermark();
        if (this.currentWatermark > lastWatermark) {
            this.output.emitWatermark(new Watermark(this.currentWatermark));
        }
    }

    @Override
    public void processWatermark(Watermark mark) throws Exception {
    }
}

