/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.plugable.DeserializationDelegate;
import org.apache.flink.runtime.plugable.NonReusingDeserializationDelegate;
import org.apache.flink.runtime.util.event.EventListener;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.BarrierBuffer;
import org.apache.flink.streaming.runtime.io.BarrierTracker;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.InputGateUtil;
import org.apache.flink.streaming.runtime.streamrecord.MultiplexingStreamRecordSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecordSerializer;

public class StreamTwoInputProcessor<IN1, IN2> {
    private final RecordDeserializer<DeserializationDelegate<StreamElement>>[] recordDeserializers;
    private RecordDeserializer<DeserializationDelegate<StreamElement>> currentRecordDeserializer;
    private int currentChannel = -1;
    private boolean isFinished;
    private final CheckpointBarrierHandler barrierHandler;
    private final long[] watermarks1;
    private long lastEmittedWatermark1;
    private final long[] watermarks2;
    private long lastEmittedWatermark2;
    private final int numInputChannels1;
    private final DeserializationDelegate<StreamElement> deserializationDelegate1;
    private final DeserializationDelegate<StreamElement> deserializationDelegate2;

    public StreamTwoInputProcessor(Collection<InputGate> inputGates1, Collection<InputGate> inputGates2, TypeSerializer<IN1> inputSerializer1, TypeSerializer<IN2> inputSerializer2, EventListener<CheckpointBarrier> checkpointListener, CheckpointingMode checkpointMode, IOManager ioManager, boolean enableWatermarkMultiplexing) throws IOException {
        TypeSerializer ser;
        InputGate inputGate = InputGateUtil.createInputGate(inputGates1, inputGates2);
        if (checkpointMode == CheckpointingMode.EXACTLY_ONCE) {
            this.barrierHandler = new BarrierBuffer(inputGate, ioManager);
        } else if (checkpointMode == CheckpointingMode.AT_LEAST_ONCE) {
            this.barrierHandler = new BarrierTracker(inputGate);
        } else {
            throw new IllegalArgumentException("Unrecognized CheckpointingMode: " + (Object)((Object)checkpointMode));
        }
        if (checkpointListener != null) {
            this.barrierHandler.registerCheckpointEventHandler(checkpointListener);
        }
        if (enableWatermarkMultiplexing) {
            ser = new MultiplexingStreamRecordSerializer<IN1>(inputSerializer1);
            this.deserializationDelegate1 = new NonReusingDeserializationDelegate(ser);
        } else {
            ser = new StreamRecordSerializer<IN1>(inputSerializer1);
            this.deserializationDelegate1 = new NonReusingDeserializationDelegate(ser);
        }
        if (enableWatermarkMultiplexing) {
            ser = new MultiplexingStreamRecordSerializer<IN2>(inputSerializer2);
            this.deserializationDelegate2 = new NonReusingDeserializationDelegate(ser);
        } else {
            ser = new StreamRecordSerializer<IN2>(inputSerializer2);
            this.deserializationDelegate2 = new NonReusingDeserializationDelegate(ser);
        }
        this.recordDeserializers = new SpillingAdaptiveSpanningRecordDeserializer[inputGate.getNumberOfInputChannels()];
        for (int i = 0; i < this.recordDeserializers.length; ++i) {
            this.recordDeserializers[i] = new SpillingAdaptiveSpanningRecordDeserializer();
        }
        int numInputChannels1 = 0;
        for (InputGate gate : inputGates1) {
            numInputChannels1 += gate.getNumberOfInputChannels();
        }
        this.numInputChannels1 = numInputChannels1;
        int numInputChannels2 = inputGate.getNumberOfInputChannels() - numInputChannels1;
        this.watermarks1 = new long[numInputChannels1];
        Arrays.fill(this.watermarks1, Long.MIN_VALUE);
        this.lastEmittedWatermark1 = Long.MIN_VALUE;
        this.watermarks2 = new long[numInputChannels2];
        Arrays.fill(this.watermarks2, Long.MIN_VALUE);
        this.lastEmittedWatermark2 = Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processInput(TwoInputStreamOperator<IN1, IN2, ?> streamOperator, Object lock) throws Exception {
        block16: {
            AbstractEvent event;
            if (this.isFinished) {
                return false;
            }
            while (true) {
                BufferOrEvent bufferOrEvent;
                if (this.currentRecordDeserializer != null) {
                    RecordDeserializer.DeserializationResult result = this.currentChannel < this.numInputChannels1 ? this.currentRecordDeserializer.getNextRecord(this.deserializationDelegate1) : this.currentRecordDeserializer.getNextRecord(this.deserializationDelegate2);
                    if (result.isBufferConsumed()) {
                        this.currentRecordDeserializer.getCurrentBuffer().recycle();
                        this.currentRecordDeserializer = null;
                    }
                    if (result.isFullRecord()) {
                        StreamElement recordOrWatermark;
                        if (this.currentChannel < this.numInputChannels1) {
                            recordOrWatermark = (StreamElement)this.deserializationDelegate1.getInstance();
                            if (recordOrWatermark.isWatermark()) {
                                this.handleWatermark(streamOperator, (Watermark)recordOrWatermark, this.currentChannel, lock);
                                continue;
                            }
                            Object object = lock;
                            synchronized (object) {
                                streamOperator.processElement1(recordOrWatermark.asRecord());
                            }
                            return true;
                        }
                        recordOrWatermark = (StreamElement)this.deserializationDelegate2.getInstance();
                        if (recordOrWatermark.isWatermark()) {
                            this.handleWatermark(streamOperator, recordOrWatermark.asWatermark(), this.currentChannel, lock);
                            continue;
                        }
                        Object object = lock;
                        synchronized (object) {
                            streamOperator.processElement2(recordOrWatermark.asRecord());
                        }
                        return true;
                    }
                }
                if ((bufferOrEvent = this.barrierHandler.getNextNonBlocked()) == null) break block16;
                if (bufferOrEvent.isBuffer()) {
                    this.currentChannel = bufferOrEvent.getChannelIndex();
                    this.currentRecordDeserializer = this.recordDeserializers[this.currentChannel];
                    this.currentRecordDeserializer.setNextBuffer(bufferOrEvent.getBuffer());
                    continue;
                }
                event = bufferOrEvent.getEvent();
                if (event.getClass() != EndOfPartitionEvent.class) break;
            }
            throw new IOException("Unexpected event: " + event);
        }
        this.isFinished = true;
        if (!this.barrierHandler.isEmpty()) {
            throw new IllegalStateException("Trailing data in checkpoint barrier handler.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWatermark(TwoInputStreamOperator<IN1, IN2, ?> operator, Watermark mark, int channelIndex, Object lock) throws Exception {
        if (channelIndex < this.numInputChannels1) {
            long watermarkMillis = mark.getTimestamp();
            if (watermarkMillis > this.watermarks1[channelIndex]) {
                this.watermarks1[channelIndex] = watermarkMillis;
                long newMinWatermark = Long.MAX_VALUE;
                for (long wm : this.watermarks1) {
                    newMinWatermark = Math.min(wm, newMinWatermark);
                }
                if (newMinWatermark > this.lastEmittedWatermark1) {
                    this.lastEmittedWatermark1 = newMinWatermark;
                    Object object = lock;
                    synchronized (object) {
                        operator.processWatermark1(new Watermark(this.lastEmittedWatermark1));
                    }
                }
            }
        } else {
            long watermarkMillis = mark.getTimestamp();
            if (watermarkMillis > this.watermarks2[channelIndex -= this.numInputChannels1]) {
                this.watermarks2[channelIndex] = watermarkMillis;
                long newMinWatermark = Long.MAX_VALUE;
                for (long wm : this.watermarks2) {
                    newMinWatermark = Math.min(wm, newMinWatermark);
                }
                if (newMinWatermark > this.lastEmittedWatermark2) {
                    this.lastEmittedWatermark2 = newMinWatermark;
                    Object object = lock;
                    synchronized (object) {
                        operator.processWatermark2(new Watermark(this.lastEmittedWatermark2));
                    }
                }
            }
        }
    }

    public void setReporter(AccumulatorRegistry.Reporter reporter) {
        for (RecordDeserializer<DeserializationDelegate<StreamElement>> deserializer : this.recordDeserializers) {
            deserializer.setReporter(reporter);
        }
    }

    public void cleanup() throws IOException {
        for (RecordDeserializer<DeserializationDelegate<StreamElement>> deserializer : this.recordDeserializers) {
            Buffer buffer = deserializer.getCurrentBuffer();
            if (buffer == null || buffer.isRecycled()) continue;
            buffer.recycle();
        }
        this.barrierHandler.cleanup();
    }
}

