/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.ArrayList;
import org.apache.flink.streaming.api.collector.selector.OutputSelectorWrapper;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Collector;

public class CollectorWrapper<OUT>
implements Output<StreamRecord<OUT>> {
    private OutputSelectorWrapper<OUT> outputSelectorWrapper;
    private ArrayList<Output<StreamRecord<OUT>>> allOutputs;

    public CollectorWrapper(OutputSelectorWrapper<OUT> outputSelectorWrapper) {
        this.outputSelectorWrapper = outputSelectorWrapper;
        this.allOutputs = new ArrayList();
    }

    public void addCollector(Output<StreamRecord<OUT>> output, StreamEdge edge) {
        this.outputSelectorWrapper.addCollector(output, edge);
        this.allOutputs.add(output);
    }

    public void collect(StreamRecord<OUT> record) {
        for (Collector<StreamRecord<OUT>> output : this.outputSelectorWrapper.getSelectedOutputs(record.getValue())) {
            output.collect(record);
        }
    }

    @Override
    public void emitWatermark(Watermark mark) {
        for (Output<StreamRecord<OUT>> output : this.allOutputs) {
            output.emitWatermark(mark);
        }
    }

    public void close() {
    }
}

