/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.triggers;

import java.io.Serializable;
import org.apache.flink.api.common.state.OperatorState;
import org.apache.flink.streaming.api.windowing.windows.Window;

public interface Trigger<T, W extends Window>
extends Serializable {
    public TriggerResult onElement(T var1, long var2, W var4, TriggerContext var5) throws Exception;

    public TriggerResult onProcessingTime(long var1, W var3, TriggerContext var4) throws Exception;

    public TriggerResult onEventTime(long var1, W var3, TriggerContext var4) throws Exception;

    public static interface TriggerContext {
        public void registerProcessingTimeTimer(long var1);

        public void registerEventTimeTimer(long var1);

        public <S extends Serializable> OperatorState<S> getKeyValueState(String var1, S var2);
    }

    public static enum TriggerResult {
        CONTINUE(false, false),
        FIRE_AND_PURGE(true, true),
        FIRE(true, false),
        PURGE(false, true);

        private final boolean fire;
        private final boolean purge;

        private TriggerResult(boolean fire, boolean purge) {
            this.purge = purge;
            this.fire = fire;
        }

        public boolean isFire() {
            return this.fire;
        }

        public boolean isPurge() {
            return this.purge;
        }

        public static TriggerResult merge(TriggerResult a, TriggerResult b) {
            if (a.purge || b.purge) {
                if (a.fire || b.fire) {
                    return FIRE_AND_PURGE;
                }
                return PURGE;
            }
            if (a.fire || b.fire) {
                return FIRE;
            }
            return CONTINUE;
        }
    }
}

