/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.time;

import java.util.concurrent.TimeUnit;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.windowing.time.AbstractTime;
import org.apache.flink.streaming.api.windowing.time.EventTime;
import org.apache.flink.streaming.api.windowing.time.ProcessingTime;

public final class Time
extends AbstractTime {
    private Time(long size, TimeUnit unit) {
        super(size, unit);
    }

    @Override
    public AbstractTime makeSpecificBasedOnTimeCharacteristic(TimeCharacteristic timeCharacteristic) {
        switch (timeCharacteristic) {
            case ProcessingTime: {
                return ProcessingTime.of(this.getSize(), this.getUnit());
            }
            case IngestionTime: 
            case EventTime: {
                return EventTime.of(this.getSize(), this.getUnit());
            }
        }
        throw new IllegalArgumentException("Unknown time characteristic");
    }

    public static Time of(long size, TimeUnit unit) {
        return new Time(size, unit);
    }

    public static Time milliseconds(long milliseconds) {
        return Time.of(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static Time seconds(long seconds) {
        return Time.of(seconds, TimeUnit.SECONDS);
    }

    public static Time minutes(long minutes) {
        return Time.of(minutes, TimeUnit.MINUTES);
    }

    public static Time hours(long hours) {
        return Time.of(hours, TimeUnit.HOURS);
    }

    public static Time days(long days) {
        return Time.of(days, TimeUnit.DAYS);
    }
}

