/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.assigners;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.AbstractTime;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;

public class SlidingTimeWindows
extends WindowAssigner<Object, TimeWindow> {
    private static final long serialVersionUID = 1L;
    private final long size;
    private final long slide;

    private SlidingTimeWindows(long size, long slide) {
        this.size = size;
        this.slide = slide;
    }

    @Override
    public Collection<TimeWindow> assignWindows(Object element, long timestamp) {
        long lastStart;
        ArrayList<TimeWindow> windows = new ArrayList<TimeWindow>((int)(this.size / this.slide));
        for (long start = lastStart = timestamp - timestamp % this.slide; start > timestamp - this.size; start -= this.slide) {
            windows.add(new TimeWindow(start, start + this.size));
        }
        return windows;
    }

    public long getSize() {
        return this.size;
    }

    public long getSlide() {
        return this.slide;
    }

    @Override
    public Trigger<Object, TimeWindow> getDefaultTrigger(StreamExecutionEnvironment env) {
        if (env.getStreamTimeCharacteristic() == TimeCharacteristic.ProcessingTime) {
            return ProcessingTimeTrigger.create();
        }
        return EventTimeTrigger.create();
    }

    public String toString() {
        return "SlidingTimeWindows(" + this.size + ", " + this.slide + ")";
    }

    public static SlidingTimeWindows of(AbstractTime size, AbstractTime slide) {
        return new SlidingTimeWindows(size.toMilliseconds(), slide.toMilliseconds());
    }

    @Override
    public TypeSerializer<TimeWindow> getWindowSerializer(ExecutionConfig executionConfig) {
        return new TimeWindow.Serializer();
    }
}

