/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.StreamTransformation;

public class OneInputTransformation<IN, OUT>
extends StreamTransformation<OUT> {
    private final StreamTransformation<IN> input;
    private final OneInputStreamOperator<IN, OUT> operator;
    private KeySelector<IN, ?> stateKeySelector;
    private TypeInformation<?> stateKeyType;

    public OneInputTransformation(StreamTransformation<IN> input, String name, OneInputStreamOperator<IN, OUT> operator, TypeInformation<OUT> outputType, int parallelism) {
        super(name, outputType, parallelism);
        this.input = input;
        this.operator = operator;
    }

    public StreamTransformation<IN> getInput() {
        return this.input;
    }

    public TypeInformation<IN> getInputType() {
        return this.input.getOutputType();
    }

    public OneInputStreamOperator<IN, OUT> getOperator() {
        return this.operator;
    }

    public void setStateKeySelector(KeySelector<IN, ?> stateKeySelector) {
        this.stateKeySelector = stateKeySelector;
    }

    public KeySelector<IN, ?> getStateKeySelector() {
        return this.stateKeySelector;
    }

    public void setStateKeyType(TypeInformation<?> stateKeyType) {
        this.stateKeyType = stateKeyType;
    }

    public TypeInformation<?> getStateKeyType() {
        return this.stateKeyType;
    }

    @Override
    public Collection<StreamTransformation<?>> getTransitivePredecessors() {
        ArrayList<StreamTransformation<?>> result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        this.operator.setChainingStrategy(strategy);
    }
}

