/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Collector;

public class TimestampedCollector<T>
implements Collector<T> {
    private final Output<StreamRecord<T>> output;
    private final StreamRecord<T> reuse;
    private long timestamp;

    public TimestampedCollector(Output<StreamRecord<T>> output) {
        this.output = output;
        this.reuse = new StreamRecord<Object>(null);
    }

    public void collect(T record) {
        this.output.collect(this.reuse.replace(record, this.timestamp));
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void close() {
        this.output.close();
    }
}

