/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.streaming.api.functions.source.EventTimeSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class StreamSource<T>
extends AbstractUdfStreamOperator<T, SourceFunction<T>>
implements StreamOperator<T> {
    private static final long serialVersionUID = 1L;
    private transient SourceFunction.SourceContext<T> ctx;

    public StreamSource(SourceFunction<T> sourceFunction) {
        super(sourceFunction);
        this.chainingStrategy = ChainingStrategy.HEAD;
    }

    public void run(Object lockingObject, Output<StreamRecord<T>> collector) throws Exception {
        ExecutionConfig executionConfig = this.getExecutionConfig();
        this.ctx = this.userFunction instanceof EventTimeSourceFunction ? new ManualWatermarkContext<T>(lockingObject, collector) : (executionConfig.getAutoWatermarkInterval() > 0L ? new AutomaticWatermarkContext<T>(lockingObject, collector, executionConfig) : (executionConfig.areTimestampsEnabled() ? new NonWatermarkContext<T>(lockingObject, collector) : new NonTimestampContext<T>(lockingObject, collector)));
        ((SourceFunction)this.userFunction).run(this.ctx);
        this.ctx.close();
    }

    public void cancel() {
        ((SourceFunction)this.userFunction).cancel();
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    public static class ManualWatermarkContext<T>
    implements SourceFunction.SourceContext<T> {
        private final Object lockingObject;
        private final Output<StreamRecord<T>> output;
        private final StreamRecord<T> reuse;

        public ManualWatermarkContext(Object lockingObject, Output<StreamRecord<T>> output) {
            this.lockingObject = lockingObject;
            this.output = output;
            this.reuse = new StreamRecord<Object>(null);
        }

        @Override
        public void collect(T element) {
            throw new UnsupportedOperationException("Manual-Timestamp sources can only emit elements with a timestamp. Please use collectWithTimestamp().");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void collectWithTimestamp(T element, long timestamp) {
            Object object = this.lockingObject;
            synchronized (object) {
                this.output.collect(this.reuse.replace(element, timestamp));
            }
        }

        @Override
        public void emitWatermark(Watermark mark) {
            this.output.emitWatermark(mark);
        }

        @Override
        public Object getCheckpointLock() {
            return this.lockingObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lockingObject;
            synchronized (object) {
                this.output.emitWatermark(new Watermark(Long.MAX_VALUE));
            }
        }
    }

    public static class AutomaticWatermarkContext<T>
    implements SourceFunction.SourceContext<T> {
        private final ScheduledExecutorService scheduleExecutor;
        private final ScheduledFuture<?> watermarkTimer;
        private final long watermarkInterval;
        private final Object lockingObject;
        private final Output<StreamRecord<T>> output;
        private final StreamRecord<T> reuse;
        private volatile long lastWatermarkTime;

        public AutomaticWatermarkContext(Object lockingObjectParam, Output<StreamRecord<T>> outputParam, ExecutionConfig executionConfig) {
            this.lockingObject = lockingObjectParam;
            this.output = outputParam;
            this.reuse = new StreamRecord<Object>(null);
            this.watermarkInterval = executionConfig.getAutoWatermarkInterval();
            this.scheduleExecutor = Executors.newScheduledThreadPool(1);
            this.watermarkTimer = this.scheduleExecutor.scheduleAtFixedRate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long watermarkTime;
                    long currentTime = System.currentTimeMillis();
                    if (currentTime > (watermarkTime = currentTime - currentTime % AutomaticWatermarkContext.this.watermarkInterval) && watermarkTime - AutomaticWatermarkContext.this.lastWatermarkTime >= AutomaticWatermarkContext.this.watermarkInterval) {
                        Object object = AutomaticWatermarkContext.this.lockingObject;
                        synchronized (object) {
                            if (currentTime > watermarkTime && watermarkTime - AutomaticWatermarkContext.this.lastWatermarkTime >= AutomaticWatermarkContext.this.watermarkInterval) {
                                AutomaticWatermarkContext.this.output.emitWatermark(new Watermark(watermarkTime));
                                AutomaticWatermarkContext.this.lastWatermarkTime = watermarkTime;
                            }
                        }
                    }
                }
            }, 0L, this.watermarkInterval, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void collect(T element) {
            Object object = this.lockingObject;
            synchronized (object) {
                long currentTime = System.currentTimeMillis();
                this.output.collect(this.reuse.replace(element, currentTime));
                long watermarkTime = currentTime - currentTime % this.watermarkInterval;
                if (currentTime > watermarkTime && watermarkTime - this.lastWatermarkTime >= this.watermarkInterval) {
                    this.output.emitWatermark(new Watermark(watermarkTime));
                    this.lastWatermarkTime = watermarkTime;
                }
            }
        }

        @Override
        public void collectWithTimestamp(T element, long timestamp) {
            throw new UnsupportedOperationException("Automatic-Timestamp sources cannot emit elements with a timestamp. See interface ManualTimestampSourceFunction if you want to manually assign timestamps to elements.");
        }

        @Override
        public void emitWatermark(Watermark mark) {
            throw new UnsupportedOperationException("Automatic-Timestamp sources cannot emit elements with a timestamp. See interface ManualTimestampSourceFunction if you want to manually assign timestamps to elements.");
        }

        @Override
        public Object getCheckpointLock() {
            return this.lockingObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.watermarkTimer.cancel(true);
            this.scheduleExecutor.shutdownNow();
            Object object = this.lockingObject;
            synchronized (object) {
                this.output.emitWatermark(new Watermark(Long.MAX_VALUE));
            }
        }
    }

    public static class NonWatermarkContext<T>
    implements SourceFunction.SourceContext<T> {
        private final Object lockingObject;
        private final Output<StreamRecord<T>> output;
        private final StreamRecord<T> reuse;

        public NonWatermarkContext(Object lockingObjectParam, Output<StreamRecord<T>> outputParam) {
            this.lockingObject = lockingObjectParam;
            this.output = outputParam;
            this.reuse = new StreamRecord<Object>(null);
        }

        @Override
        public void collect(T element) {
            long currentTime = System.currentTimeMillis();
            this.output.collect(this.reuse.replace(element, currentTime));
        }

        @Override
        public void collectWithTimestamp(T element, long timestamp) {
            throw new UnsupportedOperationException("Automatic-Timestamp sources cannot emit elements with a timestamp. See interface ManualTimestampSourceFunction if you want to manually assign timestamps to elements.");
        }

        @Override
        public void emitWatermark(Watermark mark) {
            throw new UnsupportedOperationException("Automatic-Timestamp sources cannot emit elements with a timestamp. See interface ManualTimestampSourceFunction if you want to manually assign timestamps to elements.");
        }

        @Override
        public Object getCheckpointLock() {
            return this.lockingObject;
        }

        @Override
        public void close() {
        }
    }

    public static class NonTimestampContext<T>
    implements SourceFunction.SourceContext<T> {
        private final Object lockingObject;
        private final Output<StreamRecord<T>> output;
        private final StreamRecord<T> reuse;

        public NonTimestampContext(Object lockingObjectParam, Output<StreamRecord<T>> outputParam) {
            this.lockingObject = lockingObjectParam;
            this.output = outputParam;
            this.reuse = new StreamRecord<Object>(null);
        }

        @Override
        public void collect(T element) {
            this.output.collect(this.reuse.replace(element, 0L));
        }

        @Override
        public void collectWithTimestamp(T element, long timestamp) {
            throw new UnsupportedOperationException("Automatic-Timestamp sources cannot emit elements with a timestamp. See interface ManualTimestampSourceFunction if you want to manually assign timestamps to elements.");
        }

        @Override
        public void emitWatermark(Watermark mark) {
            throw new UnsupportedOperationException("Automatic-Timestamp sources cannot emit elements with a timestamp. See interface ManualTimestampSourceFunction if you want to manually assign timestamps to elements.");
        }

        @Override
        public Object getCheckpointLock() {
            return this.lockingObject;
        }

        @Override
        public void close() {
        }
    }
}

