/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class StreamProject<IN, OUT extends Tuple>
extends AbstractStreamOperator<OUT>
implements OneInputStreamOperator<IN, OUT> {
    private static final long serialVersionUID = 1L;
    private TypeSerializer<OUT> outSerializer;
    private int[] fields;
    private int numFields;
    private transient OUT outTuple;

    public StreamProject(int[] fields, TypeSerializer<OUT> outSerializer) {
        this.fields = fields;
        this.numFields = this.fields.length;
        this.outSerializer = outSerializer;
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        for (int i = 0; i < this.numFields; ++i) {
            this.outTuple.setField(((Tuple)element.getValue()).getField(this.fields[i]), i);
        }
        this.output.collect(element.replace(this.outTuple));
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.outTuple = (Tuple)this.outSerializer.createInstance();
    }

    @Override
    public void processWatermark(Watermark mark) throws Exception {
        this.output.emitWatermark(mark);
    }
}

