/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.OperatorState;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.runtime.operators.Triggerable;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamTaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamOperator<OUT>
implements StreamOperator<OUT>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractStreamOperator.class);
    protected ChainingStrategy chainingStrategy = ChainingStrategy.HEAD;
    private boolean inputCopyDisabled = false;
    private transient StreamTask<?, ?> container;
    private transient StreamConfig config;
    protected transient Output<StreamRecord<OUT>> output;
    private transient StreamingRuntimeContext runtimeContext;
    private transient KeySelector<?, ?> stateKeySelector;
    private transient KvState<?, ?, ?>[] keyValueStates;
    private transient HashMap<String, KvState<?, ?, ?>> keyValueStatesByName;
    private transient TypeSerializer<?> keySerializer;
    private transient HashMap<String, KvStateSnapshot<?, ?, ?>> keyValueStateSnapshots;

    @Override
    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<OUT>> output) {
        this.container = containingTask;
        this.config = config;
        this.output = output;
        this.runtimeContext = new StreamingRuntimeContext(this, this.container.getEnvironment(), this.container.getAccumulatorMap());
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void dispose() {
        if (this.keyValueStates != null) {
            for (KvState<?, ?, ?> state : this.keyValueStates) {
                state.dispose();
            }
        }
    }

    @Override
    public StreamTaskState snapshotOperatorState(long checkpointId, long timestamp) throws Exception {
        StreamTaskState state = new StreamTaskState();
        if (this.keyValueStates != null) {
            HashMap snapshots = new HashMap(this.keyValueStatesByName.size());
            for (Map.Entry<String, KvState<?, ?, ?>> entry : this.keyValueStatesByName.entrySet()) {
                KvStateSnapshot snapshot = entry.getValue().shapshot(checkpointId, timestamp);
                snapshots.put(entry.getKey(), snapshot);
            }
            state.setKvStates(snapshots);
        }
        return state;
    }

    @Override
    public void restoreState(StreamTaskState state) throws Exception {
        this.keyValueStateSnapshots = state.getKvStates();
    }

    @Override
    public void notifyOfCompletedCheckpoint(long checkpointId) throws Exception {
    }

    public ExecutionConfig getExecutionConfig() {
        return this.container.getExecutionConfig();
    }

    public StreamConfig getOperatorConfig() {
        return this.config;
    }

    public StreamTask<?, ?> getContainingTask() {
        return this.container;
    }

    public ClassLoader getUserCodeClassloader() {
        return this.container.getUserCodeClassLoader();
    }

    public StreamingRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public StateBackend<?> getStateBackend() {
        return this.container.getStateBackend();
    }

    protected void registerTimer(long time, Triggerable target) {
        this.container.registerTimer(time, target);
    }

    protected <V> OperatorState<V> createKeyValueState(String name, TypeInformation<V> stateType, V defaultValue) throws Exception {
        return this.createKeyValueState(name, stateType.createSerializer(this.getExecutionConfig()), defaultValue);
    }

    protected <K, V, Backend extends StateBackend<Backend>> OperatorState<V> createKeyValueState(String name, TypeSerializer<V> valueSerializer, V defaultValue) throws Exception {
        KvStateSnapshot<?, ?, ?> snapshot;
        Object keySerializer;
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (this.keyValueStatesByName != null && this.keyValueStatesByName.containsKey(name)) {
            throw new IllegalStateException("The key/value state has already been created");
        }
        if (this.stateKeySelector == null) {
            this.stateKeySelector = this.config.getStatePartitioner(this.getUserCodeClassloader());
            if (this.stateKeySelector == null) {
                throw new UnsupportedOperationException("The function or operator is not executed on a KeyedStream and can hence not access the key/value state");
            }
            keySerializer = this.config.getStateKeySerializer(this.getUserCodeClassloader());
            if (keySerializer == null) {
                throw new Exception("State key serializer has not been configured in the config.");
            }
            this.keySerializer = keySerializer;
        } else if (this.keySerializer != null) {
            keySerializer = this.keySerializer;
        } else {
            throw new RuntimeException();
        }
        StateBackend<?> stateBackend = this.container.getStateBackend();
        KvState kvstate = null;
        if (this.keyValueStateSnapshots != null && (snapshot = this.keyValueStateSnapshots.remove(name)) != null) {
            kvstate = snapshot.restoreState(stateBackend, keySerializer, valueSerializer, defaultValue, this.getUserCodeClassloader());
        }
        if (kvstate == null) {
            kvstate = stateBackend.createKvState(keySerializer, valueSerializer, defaultValue);
        }
        if (this.keyValueStatesByName == null) {
            this.keyValueStatesByName = new HashMap();
        }
        this.keyValueStatesByName.put(name, kvstate);
        this.keyValueStates = this.keyValueStatesByName.values().toArray(new KvState[this.keyValueStatesByName.size()]);
        return kvstate;
    }

    @Override
    public void setKeyContextElement(StreamRecord record) throws Exception {
        if (this.stateKeySelector != null && this.keyValueStates != null) {
            KeySelector<?, ?> selector = this.stateKeySelector;
            for (KvState<?, ?, ?> kv : this.keyValueStates) {
                kv.setCurrentKey(selector.getKey(record.getValue()));
            }
        }
    }

    public void setKeyContext(Object key) {
        if (this.keyValueStates != null) {
            for (KvState<?, ?, ?> kv : this.keyValueStates) {
                kv.setCurrentKey(key);
            }
        }
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        this.chainingStrategy = strategy;
    }

    @Override
    public final ChainingStrategy getChainingStrategy() {
        return this.chainingStrategy;
    }

    @Override
    public boolean isInputCopyingDisabled() {
        return this.inputCopyDisabled;
    }

    public void disableInputCopy() {
        this.inputCopyDisabled = true;
    }
}

