/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.FileSourceFunction;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.transformations.CoFeedbackTransformation;
import org.apache.flink.streaming.api.transformations.FeedbackTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.SelectTransformation;
import org.apache.flink.streaming.api.transformations.SinkTransformation;
import org.apache.flink.streaming.api.transformations.SourceTransformation;
import org.apache.flink.streaming.api.transformations.SplitTransformation;
import org.apache.flink.streaming.api.transformations.StreamTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.api.transformations.UnionTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamGraphGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(StreamGraphGenerator.class);
    private StreamGraph streamGraph;
    private final StreamExecutionEnvironment env;
    protected static Integer iterationIdCounter = 0;
    private Map<StreamTransformation<?>, Collection<Integer>> alreadyTransformed;

    public static int getNewIterationNodeId() {
        Integer n = iterationIdCounter;
        Integer n2 = iterationIdCounter = Integer.valueOf(iterationIdCounter - 1);
        return iterationIdCounter;
    }

    private StreamGraphGenerator(StreamExecutionEnvironment env) {
        this.streamGraph = new StreamGraph(env);
        this.streamGraph.setChaining(env.isChainingEnabled());
        if (env.getCheckpointInterval() > 0L) {
            this.streamGraph.setCheckpointingEnabled(true);
            this.streamGraph.setCheckpointingInterval(env.getCheckpointInterval());
            this.streamGraph.setCheckpointingMode(env.getCheckpointingMode());
        }
        this.streamGraph.setStateBackend(env.getStateBackend());
        if (env.isForceCheckpointing()) {
            this.streamGraph.forceCheckpoint();
        }
        this.env = env;
        this.alreadyTransformed = new HashMap();
    }

    public static StreamGraph generate(StreamExecutionEnvironment env, List<StreamTransformation<?>> transformations) {
        return new StreamGraphGenerator(env).generateInternal(transformations);
    }

    private StreamGraph generateInternal(List<StreamTransformation<?>> transformations) {
        for (StreamTransformation<?> transformation : transformations) {
            this.transform(transformation);
        }
        return this.streamGraph;
    }

    private Collection<Integer> transform(StreamTransformation<?> transform) {
        Collection<Integer> transformedIds;
        if (this.alreadyTransformed.containsKey(transform)) {
            return this.alreadyTransformed.get(transform);
        }
        LOG.debug("Transforming " + transform);
        transform.getOutputType();
        if (transform instanceof OneInputTransformation) {
            transformedIds = this.transformOnInputTransform((OneInputTransformation)transform);
        } else if (transform instanceof TwoInputTransformation) {
            transformedIds = this.transformTwoInputTransform((TwoInputTransformation)transform);
        } else if (transform instanceof SourceTransformation) {
            transformedIds = this.transformSource((SourceTransformation)transform);
        } else if (transform instanceof SinkTransformation) {
            transformedIds = this.transformSink((SinkTransformation)transform);
        } else if (transform instanceof UnionTransformation) {
            transformedIds = this.transformUnion((UnionTransformation)transform);
        } else if (transform instanceof SplitTransformation) {
            transformedIds = this.transformSplit((SplitTransformation)transform);
        } else if (transform instanceof SelectTransformation) {
            transformedIds = this.transformSelect((SelectTransformation)transform);
        } else if (transform instanceof FeedbackTransformation) {
            transformedIds = this.transformFeedback((FeedbackTransformation)transform);
        } else if (transform instanceof CoFeedbackTransformation) {
            transformedIds = this.transformCoFeedback((CoFeedbackTransformation)transform);
        } else if (transform instanceof PartitionTransformation) {
            transformedIds = this.transformPartition((PartitionTransformation)transform);
        } else {
            throw new IllegalStateException("Unknown transformation: " + transform);
        }
        if (!this.alreadyTransformed.containsKey(transform)) {
            this.alreadyTransformed.put(transform, transformedIds);
        }
        if (transform.getBufferTimeout() > 0L) {
            this.streamGraph.setBufferTimeout(transform.getId(), transform.getBufferTimeout());
        }
        if (transform.getResourceStrategy() != StreamGraph.ResourceStrategy.DEFAULT) {
            this.streamGraph.setResourceStrategy(transform.getId(), transform.getResourceStrategy());
        }
        return transformedIds;
    }

    private <T> Collection<Integer> transformUnion(UnionTransformation<T> union) {
        List<StreamTransformation<T>> inputs = union.getInputs();
        ArrayList<Integer> resultIds = new ArrayList<Integer>();
        for (StreamTransformation<T> input : inputs) {
            resultIds.addAll(this.transform(input));
        }
        return resultIds;
    }

    private <T> Collection<Integer> transformPartition(PartitionTransformation<T> partition) {
        StreamTransformation<T> input = partition.getInput();
        ArrayList<Integer> resultIds = new ArrayList<Integer>();
        Collection<Integer> transformedIds = this.transform(input);
        for (Integer transformedId : transformedIds) {
            int virtualId = StreamTransformation.getNewNodeId();
            this.streamGraph.addVirtualPartitionNode(transformedId, virtualId, partition.getPartitioner());
            resultIds.add(virtualId);
        }
        return resultIds;
    }

    private <T> Collection<Integer> transformSplit(SplitTransformation<T> split) {
        StreamTransformation<T> input = split.getInput();
        Collection<Integer> resultIds = this.transform(input);
        if (this.alreadyTransformed.containsKey(split)) {
            return this.alreadyTransformed.get(split);
        }
        for (int inputId : resultIds) {
            this.streamGraph.addOutputSelector(inputId, split.getOutputSelector());
        }
        return resultIds;
    }

    private <T> Collection<Integer> transformSelect(SelectTransformation<T> select) {
        StreamTransformation<T> input = select.getInput();
        Collection<Integer> resultIds = this.transform(input);
        if (this.alreadyTransformed.containsKey(select)) {
            return this.alreadyTransformed.get(select);
        }
        ArrayList<Integer> virtualResultIds = new ArrayList<Integer>();
        for (int inputId : resultIds) {
            int virtualId = StreamTransformation.getNewNodeId();
            this.streamGraph.addVirtualSelectNode(inputId, virtualId, select.getSelectedNames());
            virtualResultIds.add(virtualId);
        }
        return virtualResultIds;
    }

    private <T> Collection<Integer> transformFeedback(FeedbackTransformation<T> iterate) {
        if (iterate.getFeedbackEdges().size() <= 0) {
            throw new IllegalStateException("Iteration " + iterate + " does not have any feedback edges.");
        }
        StreamTransformation<T> input = iterate.getInput();
        ArrayList<Integer> resultIds = new ArrayList<Integer>();
        resultIds.addAll(this.transform(input));
        if (this.alreadyTransformed.containsKey(iterate)) {
            return this.alreadyTransformed.get(iterate);
        }
        Tuple2<StreamNode, StreamNode> itSourceAndSink = this.streamGraph.createIterationSourceAndSink(iterate.getId(), StreamGraphGenerator.getNewIterationNodeId(), StreamGraphGenerator.getNewIterationNodeId(), iterate.getWaitTime(), iterate.getParallelism());
        StreamNode itSource = (StreamNode)itSourceAndSink.f0;
        StreamNode itSink = (StreamNode)itSourceAndSink.f1;
        this.streamGraph.setSerializers(itSource.getId(), null, null, iterate.getOutputType().createSerializer(this.env.getConfig()));
        this.streamGraph.setSerializers(itSink.getId(), iterate.getOutputType().createSerializer(this.env.getConfig()), null, null);
        resultIds.add(itSource.getId());
        this.alreadyTransformed.put(iterate, resultIds);
        for (StreamTransformation<T> feedbackEdge : iterate.getFeedbackEdges()) {
            Collection<Integer> feedbackIds = this.transform(feedbackEdge);
            for (Integer feedbackId : feedbackIds) {
                this.streamGraph.addEdge(feedbackId, itSink.getId(), 0);
            }
        }
        return resultIds;
    }

    private <F> Collection<Integer> transformCoFeedback(CoFeedbackTransformation<F> coIterate) {
        Tuple2<StreamNode, StreamNode> itSourceAndSink = this.streamGraph.createIterationSourceAndSink(coIterate.getId(), StreamGraphGenerator.getNewIterationNodeId(), StreamGraphGenerator.getNewIterationNodeId(), coIterate.getWaitTime(), coIterate.getParallelism());
        StreamNode itSource = (StreamNode)itSourceAndSink.f0;
        StreamNode itSink = (StreamNode)itSourceAndSink.f1;
        this.streamGraph.setSerializers(itSource.getId(), null, null, coIterate.getOutputType().createSerializer(this.env.getConfig()));
        this.streamGraph.setSerializers(itSink.getId(), coIterate.getOutputType().createSerializer(this.env.getConfig()), null, null);
        Set<Integer> resultIds = Collections.singleton(itSource.getId());
        this.alreadyTransformed.put(coIterate, resultIds);
        for (StreamTransformation<F> feedbackEdge : coIterate.getFeedbackEdges()) {
            Collection<Integer> feedbackIds = this.transform(feedbackEdge);
            for (Integer feedbackId : feedbackIds) {
                this.streamGraph.addEdge(feedbackId, itSink.getId(), 0);
            }
        }
        return Collections.singleton(itSource.getId());
    }

    private <T> Collection<Integer> transformSource(SourceTransformation<T> source) {
        this.streamGraph.addSource(source.getId(), source.getOperator(), null, source.getOutputType(), "Source: " + source.getName());
        if (source.getOperator().getUserFunction() instanceof FileSourceFunction) {
            FileSourceFunction fs = (FileSourceFunction)source.getOperator().getUserFunction();
            this.streamGraph.setInputFormat(source.getId(), fs.getFormat());
        }
        this.streamGraph.setParallelism(source.getId(), source.getParallelism());
        return Collections.singleton(source.getId());
    }

    private <T> Collection<Integer> transformSink(SinkTransformation<T> sink) {
        Collection<Integer> inputIds = this.transform(sink.getInput());
        this.streamGraph.addSink(sink.getId(), sink.getOperator(), sink.getInput().getOutputType(), null, "Sink: " + sink.getName());
        this.streamGraph.setParallelism(sink.getId(), sink.getParallelism());
        for (Integer inputId : inputIds) {
            this.streamGraph.addEdge(inputId, sink.getId(), 0);
        }
        if (sink.getStateKeySelector() != null) {
            TypeSerializer keySerializer = sink.getStateKeyType().createSerializer(this.env.getConfig());
            this.streamGraph.setKey(sink.getId(), sink.getStateKeySelector(), keySerializer);
        }
        return Collections.emptyList();
    }

    private <IN, OUT> Collection<Integer> transformOnInputTransform(OneInputTransformation<IN, OUT> transform) {
        Collection<Integer> inputIds = this.transform(transform.getInput());
        if (this.alreadyTransformed.containsKey(transform)) {
            return this.alreadyTransformed.get(transform);
        }
        this.streamGraph.addOperator(transform.getId(), transform.getOperator(), transform.getInputType(), transform.getOutputType(), transform.getName());
        if (transform.getStateKeySelector() != null) {
            TypeSerializer keySerializer = transform.getStateKeyType().createSerializer(this.env.getConfig());
            this.streamGraph.setKey(transform.getId(), transform.getStateKeySelector(), keySerializer);
        }
        if (transform.getStateKeyType() != null) {
            // empty if block
        }
        this.streamGraph.setParallelism(transform.getId(), transform.getParallelism());
        for (Integer inputId : inputIds) {
            this.streamGraph.addEdge(inputId, transform.getId(), 0);
        }
        return Collections.singleton(transform.getId());
    }

    private <IN1, IN2, OUT> Collection<Integer> transformTwoInputTransform(TwoInputTransformation<IN1, IN2, OUT> transform) {
        Collection<Integer> inputIds1 = this.transform(transform.getInput1());
        Collection<Integer> inputIds2 = this.transform(transform.getInput2());
        if (this.alreadyTransformed.containsKey(transform)) {
            return this.alreadyTransformed.get(transform);
        }
        this.streamGraph.addCoOperator(transform.getId(), transform.getOperator(), transform.getInputType1(), transform.getInputType2(), transform.getOutputType(), transform.getName());
        this.streamGraph.setParallelism(transform.getId(), transform.getParallelism());
        for (Integer inputId : inputIds1) {
            this.streamGraph.addEdge(inputId, transform.getId(), 1);
        }
        for (Integer inputId : inputIds2) {
            this.streamGraph.addEdge(inputId, transform.getId(), 2);
        }
        return Collections.singleton(transform.getId());
    }
}

