/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class JSONGenerator {
    public static final String STEPS = "step_function";
    public static final String ID = "id";
    public static final String SIDE = "side";
    public static final String SHIP_STRATEGY = "ship_strategy";
    public static final String PREDECESSORS = "predecessors";
    public static final String TYPE = "type";
    public static final String PACT = "pact";
    public static final String CONTENTS = "contents";
    public static final String PARALLELISM = "parallelism";
    private StreamGraph streamGraph;

    public JSONGenerator(StreamGraph streamGraph) {
        this.streamGraph = streamGraph;
    }

    public String getJSON() throws JSONException {
        JSONObject json = new JSONObject();
        JSONArray nodes = new JSONArray();
        json.put("nodes", (Object)nodes);
        ArrayList<Integer> operatorIDs = new ArrayList<Integer>(this.streamGraph.getVertexIDs());
        Collections.sort(operatorIDs, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (JSONGenerator.this.streamGraph.getSinkIDs().contains(o1)) {
                    return 1;
                }
                if (JSONGenerator.this.streamGraph.getSinkIDs().contains(o2)) {
                    return -1;
                }
                return o1 - o2;
            }
        });
        this.visit(nodes, operatorIDs, new HashMap<Integer, Integer>());
        return json.toString();
    }

    private void visit(JSONArray jsonArray, List<Integer> toVisit, Map<Integer, Integer> edgeRemapings) throws JSONException {
        Integer vertexID = toVisit.get(0);
        StreamNode vertex = this.streamGraph.getStreamNode(vertexID);
        if (this.streamGraph.getSourceIDs().contains(vertexID) || Collections.disjoint(vertex.getInEdges(), toVisit)) {
            JSONObject node = new JSONObject();
            this.decorateNode(vertexID, node);
            if (!this.streamGraph.getSourceIDs().contains(vertexID)) {
                JSONArray inputs = new JSONArray();
                node.put(PREDECESSORS, (Object)inputs);
                for (StreamEdge inEdge : vertex.getInEdges()) {
                    int inputID = inEdge.getSourceId();
                    Integer mappedID = edgeRemapings.keySet().contains(inputID) ? edgeRemapings.get(inputID) : inputID;
                    this.decorateEdge(inputs, vertexID, mappedID, inputID);
                }
            }
            jsonArray.put((Object)node);
            toVisit.remove(vertexID);
        } else {
            Integer iterationHead = -1;
            for (StreamEdge inEdge : vertex.getInEdges()) {
                int operator = inEdge.getSourceId();
                if (!this.streamGraph.vertexIDtoLoopTimeout.containsKey(operator)) continue;
                iterationHead = operator;
            }
            JSONObject obj = new JSONObject();
            JSONArray iterationSteps = new JSONArray();
            obj.put(STEPS, (Object)iterationSteps);
            obj.put(ID, (Object)iterationHead);
            obj.put(PACT, (Object)"IterativeDataStream");
            obj.put(PARALLELISM, this.streamGraph.getStreamNode(iterationHead).getParallelism());
            obj.put(CONTENTS, (Object)"Stream Iteration");
            JSONArray iterationInputs = new JSONArray();
            obj.put(PREDECESSORS, (Object)iterationInputs);
            toVisit.remove(iterationHead);
            this.visitIteration(iterationSteps, toVisit, iterationHead, edgeRemapings, iterationInputs);
            jsonArray.put((Object)obj);
        }
        if (!toVisit.isEmpty()) {
            this.visit(jsonArray, toVisit, edgeRemapings);
        }
    }

    private void visitIteration(JSONArray jsonArray, List<Integer> toVisit, int headId, Map<Integer, Integer> edgeRemapings, JSONArray iterationInEdges) throws JSONException {
        Integer vertexID = toVisit.get(0);
        StreamNode vertex = this.streamGraph.getStreamNode(vertexID);
        toVisit.remove(vertexID);
        if (!this.streamGraph.vertexIDtoLoopTimeout.containsKey(vertexID)) {
            JSONObject obj = new JSONObject();
            jsonArray.put((Object)obj);
            this.decorateNode(vertexID, obj);
            JSONArray inEdges = new JSONArray();
            obj.put(PREDECESSORS, (Object)inEdges);
            for (StreamEdge inEdge : vertex.getInEdges()) {
                int inputID = inEdge.getSourceId();
                if (edgeRemapings.keySet().contains(inputID)) {
                    this.decorateEdge(inEdges, vertexID, inputID, inputID);
                    continue;
                }
                if (this.streamGraph.vertexIDtoLoopTimeout.containsKey(inputID)) continue;
                this.decorateEdge(iterationInEdges, vertexID, inputID, inputID);
            }
            edgeRemapings.put(vertexID, headId);
            this.visitIteration(jsonArray, toVisit, headId, edgeRemapings, iterationInEdges);
        }
    }

    private void decorateEdge(JSONArray inputArray, int vertexID, int mappedInputID, int inputID) throws JSONException {
        JSONObject input = new JSONObject();
        inputArray.put((Object)input);
        input.put(ID, mappedInputID);
        input.put(SHIP_STRATEGY, this.streamGraph.getStreamEdge(inputID, vertexID).getPartitioner());
        input.put(SIDE, (Object)(inputArray.length() == 0 ? "first" : "second"));
    }

    private void decorateNode(Integer vertexID, JSONObject node) throws JSONException {
        StreamNode vertex = this.streamGraph.getStreamNode(vertexID);
        node.put(ID, (Object)vertexID);
        node.put(TYPE, (Object)vertex.getOperatorName());
        if (this.streamGraph.getSourceIDs().contains(vertexID)) {
            node.put(PACT, (Object)"Data Source");
        } else if (this.streamGraph.getSinkIDs().contains(vertexID)) {
            node.put(PACT, (Object)"Data Sink");
        } else {
            node.put(PACT, (Object)"Operator");
        }
        StreamOperator<?> operator = this.streamGraph.getStreamNode(vertexID).getOperator();
        node.put(CONTENTS, (Object)vertex.getOperatorName());
        node.put(PARALLELISM, this.streamGraph.getStreamNode(vertexID).getParallelism());
    }
}

