/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.windowing;

import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.windowing.RichAllWindowFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;

public class ReduceAllWindowFunction<W extends Window, T>
extends RichAllWindowFunction<T, T, W> {
    private static final long serialVersionUID = 1L;
    private final ReduceFunction<T> reduceFunction;

    public ReduceAllWindowFunction(ReduceFunction<T> reduceFunction) {
        this.reduceFunction = reduceFunction;
    }

    public void setRuntimeContext(RuntimeContext ctx) {
        super.setRuntimeContext(ctx);
        FunctionUtils.setFunctionRuntimeContext(this.reduceFunction, (RuntimeContext)ctx);
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        FunctionUtils.openFunction(this.reduceFunction, (Configuration)parameters);
    }

    public void close() throws Exception {
        super.close();
        FunctionUtils.closeFunction(this.reduceFunction);
    }

    @Override
    public void apply(W window, Iterable<T> values, Collector<T> out) throws Exception {
        Object result = null;
        for (T v : values) {
            if (result == null) {
                result = v;
                continue;
            }
            result = this.reduceFunction.reduce(result, v);
        }
        if (result != null) {
            out.collect(result);
        }
    }
}

