/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.windowing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.InputViewDataInputStreamWrapper;
import org.apache.flink.core.memory.OutputViewDataOutputStreamWrapper;
import org.apache.flink.streaming.api.functions.windowing.AllWindowFunction;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;

public class FoldAllWindowFunction<W extends Window, T, R>
extends WrappingFunction<FoldFunction<T, R>>
implements AllWindowFunction<T, R, W>,
OutputTypeConfigurable<R> {
    private static final long serialVersionUID = 1L;
    private byte[] serializedInitialValue;
    private TypeSerializer<R> outSerializer;
    private transient R initialValue;

    public FoldAllWindowFunction(R initialValue, FoldFunction<T, R> reduceFunction) {
        super(reduceFunction);
        this.initialValue = initialValue;
    }

    public void open(Configuration configuration) throws Exception {
        super.open(configuration);
        if (this.serializedInitialValue == null) {
            throw new RuntimeException("No initial value was serialized for the fold window function. Probably the setOutputType method was not called.");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.serializedInitialValue);
        InputViewDataInputStreamWrapper in = new InputViewDataInputStreamWrapper(new DataInputStream(bais));
        this.initialValue = this.outSerializer.deserialize((DataInputView)in);
    }

    @Override
    public void apply(W window, Iterable<T> values, Collector<R> out) throws Exception {
        Object result = this.outSerializer.copy(this.initialValue);
        for (T val : values) {
            result = ((FoldFunction)this.wrappedFunction).fold(result, val);
        }
        out.collect(result);
    }

    @Override
    public void setOutputType(TypeInformation<R> outTypeInfo, ExecutionConfig executionConfig) {
        this.outSerializer = outTypeInfo.createSerializer(executionConfig);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputViewDataOutputStreamWrapper out = new OutputViewDataOutputStreamWrapper(new DataOutputStream(baos));
        try {
            this.outSerializer.serialize(this.initialValue, (DataOutputView)out);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to serialize initial value of type " + this.initialValue.getClass().getSimpleName() + " of fold window function.", ioe);
        }
        this.serializedInitialValue = baos.toByteArray();
    }
}

