/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink;

import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.streaming.api.functions.sink.FileSinkFunction;

public class FileSinkFunctionByMillis<IN>
extends FileSinkFunction<IN> {
    private static final long serialVersionUID = 1L;
    private final long millis;
    private long lastTime;

    public FileSinkFunctionByMillis(OutputFormat<IN> format, long millis) {
        super(format);
        this.millis = millis;
        this.lastTime = System.currentTimeMillis();
    }

    @Override
    protected boolean updateCondition() {
        return System.currentTimeMillis() - this.lastTime >= this.millis;
    }

    @Override
    protected void resetParameters() {
        this.tupleList.clear();
        this.lastTime = System.currentTimeMillis();
    }
}

