/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions;

import org.apache.flink.streaming.api.functions.TimestampExtractor;

public abstract class AscendingTimestampExtractor<T>
implements TimestampExtractor<T> {
    long currentTimestamp = 0L;

    public abstract long extractAscendingTimestamp(T var1, long var2);

    @Override
    public final long extractTimestamp(T element, long currentTimestamp) {
        long newTimestamp = this.extractAscendingTimestamp(element, currentTimestamp);
        if (newTimestamp < this.currentTimestamp) {
            throw new RuntimeException("Timestamp is lower than previously extracted timestamp. You should implement a custom TimestampExtractor.");
        }
        this.currentTimestamp = newTimestamp;
        return this.currentTimestamp;
    }

    @Override
    public final long extractWatermark(T element, long currentTimestamp) {
        return Long.MIN_VALUE;
    }

    @Override
    public final long getCurrentWatermark() {
        return this.currentTimestamp - 1L;
    }
}

