/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.co.CoFlatMapFunction;
import org.apache.flink.streaming.api.functions.co.CoMapFunction;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.operators.co.CoStreamFlatMap;
import org.apache.flink.streaming.api.operators.co.CoStreamMap;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;

public class ConnectedStreams<IN1, IN2> {
    protected StreamExecutionEnvironment environment;
    protected DataStream<IN1> inputStream1;
    protected DataStream<IN2> inputStream2;

    protected ConnectedStreams(StreamExecutionEnvironment env, DataStream<IN1> input1, DataStream<IN2> input2) {
        this.environment = env;
        if (input1 != null) {
            this.inputStream1 = input1;
        }
        if (input2 != null) {
            this.inputStream2 = input2;
        }
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.environment;
    }

    public DataStream<IN1> getFirstInput() {
        return this.inputStream1;
    }

    public DataStream<IN2> getSecondInput() {
        return this.inputStream2;
    }

    public TypeInformation<IN1> getType1() {
        return this.inputStream1.getType();
    }

    public TypeInformation<IN2> getType2() {
        return this.inputStream2.getType();
    }

    public ConnectedStreams<IN1, IN2> keyBy(int keyPosition1, int keyPosition2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.keyBy(keyPosition1), this.inputStream2.keyBy(keyPosition2));
    }

    public ConnectedStreams<IN1, IN2> keyBy(int[] keyPositions1, int[] keyPositions2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.keyBy(keyPositions1), this.inputStream2.keyBy(keyPositions2));
    }

    public ConnectedStreams<IN1, IN2> keyBy(String field1, String field2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.keyBy(field1), this.inputStream2.keyBy(field2));
    }

    public ConnectedStreams<IN1, IN2> keyBy(String[] fields1, String[] fields2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.keyBy(fields1), this.inputStream2.keyBy(fields2));
    }

    public ConnectedStreams<IN1, IN2> keyBy(KeySelector<IN1, ?> keySelector1, KeySelector<IN2, ?> keySelector2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.keyBy(keySelector1), this.inputStream2.keyBy(keySelector2));
    }

    public ConnectedStreams<IN1, IN2> partitionByHash(int keyPosition1, int keyPosition2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.partitionByHash(keyPosition1), this.inputStream2.partitionByHash(keyPosition2));
    }

    public ConnectedStreams<IN1, IN2> partitionByHash(int[] keyPositions1, int[] keyPositions2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.partitionByHash(keyPositions1), this.inputStream2.partitionByHash(keyPositions2));
    }

    public ConnectedStreams<IN1, IN2> partitionByHash(String field1, String field2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.partitionByHash(field1), this.inputStream2.partitionByHash(field2));
    }

    public ConnectedStreams<IN1, IN2> partitionByHash(String[] fields1, String[] fields2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.partitionByHash(fields1), this.inputStream2.partitionByHash(fields2));
    }

    public ConnectedStreams<IN1, IN2> partitionByHash(KeySelector<IN1, ?> keySelector1, KeySelector<IN2, ?> keySelector2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.partitionByHash(keySelector1), this.inputStream2.partitionByHash(keySelector2));
    }

    public <OUT> SingleOutputStreamOperator<OUT, ?> map(CoMapFunction<IN1, IN2, OUT> coMapper) {
        TypeInformation outTypeInfo = TypeExtractor.getBinaryOperatorReturnType(coMapper, CoMapFunction.class, (boolean)false, (boolean)true, this.getType1(), this.getType2(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.transform("Co-Map", outTypeInfo, new CoStreamMap<IN1, IN2, OUT>(this.inputStream1.clean(coMapper)));
    }

    public <OUT> SingleOutputStreamOperator<OUT, ?> flatMap(CoFlatMapFunction<IN1, IN2, OUT> coFlatMapper) {
        TypeInformation outTypeInfo = TypeExtractor.getBinaryOperatorReturnType(coFlatMapper, CoFlatMapFunction.class, (boolean)false, (boolean)true, this.getType1(), this.getType2(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.transform("Co-Flat Map", outTypeInfo, new CoStreamFlatMap<IN1, IN2, OUT>(this.inputStream1.clean(coFlatMapper)));
    }

    public <OUT> SingleOutputStreamOperator<OUT, ?> transform(String functionName, TypeInformation<OUT> outTypeInfo, TwoInputStreamOperator<IN1, IN2, OUT> operator) {
        this.inputStream1.getType();
        this.inputStream2.getType();
        TwoInputTransformation<IN1, IN2, OUT> transform = new TwoInputTransformation<IN1, IN2, OUT>(this.inputStream1.getTransformation(), this.inputStream2.getTransformation(), functionName, operator, outTypeInfo, this.environment.getParallelism());
        SingleOutputStreamOperator returnStream = new SingleOutputStreamOperator(this.environment, transform);
        this.getExecutionEnvironment().addOperator(transform);
        return returnStream;
    }
}

